/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.accelerator;

import com.groupcdg.pitest.accelerator.FastTestUnitFinder;
import com.groupcdg.pitest.accelerator.mockk.InternalDslMockOperations;
import com.groupcdg.pitest.accelerator.mockk.MockkOperations;
import com.groupcdg.pitest.accelerator.mockk.NoMockOperations;
import com.groupcdg.pitest.annotations.DoNotMutate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Predicate;
import org.pitest.help.PitHelpError;
import org.pitest.testapi.Configuration;
import org.pitest.testapi.TestGroupConfig;
import org.pitest.testapi.TestSuiteFinder;
import org.pitest.testapi.TestUnitFinder;

@DoNotMutate
public class FastTestConfiguration
implements Configuration {
    private final TestGroupConfig groupConfig;
    private final Predicate<String> includedMethods;

    public FastTestConfiguration(Collection<String> includedTestMethods, TestGroupConfig groupConfig) {
        this.includedMethods = this.methodFilter(includedTestMethods);
        this.groupConfig = groupConfig;
    }

    public int priority() {
        return 0;
    }

    public TestUnitFinder testUnitFinder() {
        return new FastTestUnitFinder(this.includedMethods, this.groupConfig, this.checkMockCompatibility());
    }

    public TestSuiteFinder testSuiteFinder() {
        return c -> Collections.emptyList();
    }

    public Optional<PitHelpError> verifyEnvironment() {
        return Optional.empty();
    }

    private Predicate<String> methodFilter(Collection<String> includedTestMethods) {
        if (includedTestMethods.isEmpty()) {
            return m -> true;
        }
        HashSet<String> methods = new HashSet<String>(includedTestMethods);
        return methods::contains;
    }

    private MockkOperations checkMockCompatibility() {
        try {
            Class<?> mockDsl = Class.forName("io.mockk.MockKDsl");
            mockDsl.getMethod("internalUnmockkAll", new Class[0]);
            return new InternalDslMockOperations();
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            return new NoMockOperations();
        }
    }
}

