/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.accelerator;

import com.groupcdg.pitest.accelerator.BasicFastUnitFactory;
import com.groupcdg.pitest.accelerator.FastUnitFactory;
import com.groupcdg.pitest.accelerator.MultiFastUnit;
import com.groupcdg.pitest.accelerator.ReflectionClass;
import com.groupcdg.pitest.accelerator.mockito.MockitoFastUnitFactory;
import com.groupcdg.pitest.accelerator.mockk.MockkFastUnitFactory;
import com.groupcdg.pitest.accelerator.mockk.MockkOperations;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.pitest.functional.FCollection;
import org.pitest.reflection.Reflection;
import org.pitest.testapi.Description;
import org.pitest.testapi.TestGroupConfig;
import org.pitest.testapi.TestUnit;
import org.pitest.testapi.TestUnitExecutionListener;
import org.pitest.testapi.TestUnitFinder;
import org.pitest.util.Log;

public class FastTestUnitFinder
implements TestUnitFinder {
    private static final Set<Class<? extends Annotation>> SUPPORTED_ANNOTATIONS = FastTestUnitFinder.supportedAnnotationSet();
    private static final Set<String> SUPPORTED_FIELD_ANNOTATIONS = FastTestUnitFinder.supportedFieldAnnotationSet();
    private static final String MOCKITO = "org.mockito.Mock";
    private static final String SPY = "org.mockito.Spy";
    private static final String CAPTOR = "org.mockito.Captor";
    private static final String INJECT_MOCKS = "org.mockito.InjectMocks";
    private static final String MOCKITO_EXTENSION = "org.mockito.junit.jupiter.MockitoExtension";
    private static final String MOCKITO_SETTINGS = "org.mockito.junit.jupiter.MockitoSettings";
    private static final String MOCKK = "io.mockk.impl.annotations.MockK";
    private static final String RELAXED_MOCKK = "io.mockk.impl.annotations.RelaxedMockK";
    private static final String INJECT_MOCKKS = "io.mockk.impl.annotations.InjectMockKs";
    private static final String SPYK = "io.mockk.impl.annotations.SpyK";
    private static final String MOCKK_EXTENSION = "io.mockk.junit5.MockKExtension";
    private final MockkOperations mockOperations;
    private final Set<String> includedTags;
    private final Set<String> excludedTags;
    private final Predicate<String> includedMethods;

    public FastTestUnitFinder(Predicate<String> includedMethods, TestGroupConfig groupConfig, MockkOperations mockOperations) {
        this.includedMethods = includedMethods;
        this.includedTags = groupConfig.getIncludedGroups().stream().collect(Collectors.toSet());
        this.excludedTags = groupConfig.getExcludedGroups().stream().collect(Collectors.toSet());
        this.mockOperations = mockOperations;
    }

    private static Set<Class<? extends Annotation>> supportedAnnotationSet() {
        HashSet<Class<? extends Annotation>> annotations = new HashSet<Class<? extends Annotation>>();
        annotations.add(DisplayName.class);
        annotations.add(Disabled.class);
        annotations.add(Test.class);
        annotations.add(AfterAll.class);
        annotations.add(BeforeAll.class);
        annotations.add(BeforeEach.class);
        annotations.add(AfterEach.class);
        annotations.add(Tag.class);
        annotations.add(Tags.class);
        return annotations;
    }

    private static Set<String> supportedFieldAnnotationSet() {
        HashSet<String> annotations = new HashSet<String>();
        annotations.add(MOCKK);
        annotations.add(MOCKITO);
        annotations.add(SPY);
        annotations.add(CAPTOR);
        annotations.add(INJECT_MOCKS);
        annotations.add(RELAXED_MOCKK);
        annotations.add(INJECT_MOCKKS);
        annotations.add(SPYK);
        return annotations;
    }

    public List<TestUnit> findTestUnits(Class<?> clazz, TestUnitExecutionListener unused) {
        ReflectionClass reflect = ReflectionClass.of(clazz);
        try {
            if (this.isAbstractOrSynthetic(clazz) || this.disabledAtClassLevel(clazz) || this.notSuitable(clazz) || this.hasFieldWithUnsupportedAnnotation(reflect) || this.hasUnsupportedNestedClass(clazz)) {
                return Collections.emptyList();
            }
        }
        catch (LinkageError ex) {
            Log.getLogger().warning("Could not scan " + clazz + " (" + ex.getMessage() + ")");
            return Collections.emptyList();
        }
        List<Method> testMethods = reflect.methodsMatching(this.hasEnabledTestAnnotation(clazz)).stream().filter(m -> this.includedMethods.test(m.getName())).collect(Collectors.toList());
        if (this.methodHasParams(testMethods)) {
            return Collections.emptyList();
        }
        FastUnitFactory factory = this.pickFactory(clazz);
        List<Method> beforeAlls = reflect.methodsMatching(this.hasAnnotation(BeforeAll.class));
        if (!beforeAlls.isEmpty() && !factory.supportsBeforeAlls() || this.methodHasParams(beforeAlls)) {
            return Collections.emptyList();
        }
        List<Method> afterAlls = reflect.methodsMatching(this.hasAnnotation(AfterAll.class));
        if (this.methodHasParams(afterAlls)) {
            return Collections.emptyList();
        }
        List<Method> beforeMethods = reflect.methodsMatching(this.hasAnnotation(BeforeEach.class));
        if (this.methodHasParams(beforeMethods)) {
            return Collections.emptyList();
        }
        List<Method> afters = reflect.methodsMatching(this.hasAnnotation(AfterEach.class));
        if (this.methodHasParams(afters)) {
            return Collections.emptyList();
        }
        List<TestUnit> children = testMethods.stream().map(m -> factory.makeTest(clazz, (Method)m, beforeMethods, afters)).collect(Collectors.toList());
        if (beforeAlls.isEmpty() && afterAlls.isEmpty()) {
            return children;
        }
        return this.makeCombinedUnits(children, beforeAlls, afterAlls, clazz);
    }

    private List<TestUnit> makeCombinedUnits(List<TestUnit> children, List<Method> beforeAlls, List<Method> afterAlls, Class<?> clazz) {
        AtomicInteger counter = new AtomicInteger();
        return FCollection.splitToLength((int)3, children).stream().map(ts -> new MultiFastUnit((List<TestUnit>)ts, beforeAlls, afterAlls, new Description("grouped_tests" + counter.incrementAndGet(), clazz))).collect(Collectors.toList());
    }

    private FastUnitFactory pickFactory(Class<?> clazz) {
        if (Arrays.stream(clazz.getDeclaredAnnotations()).anyMatch(this::isSupportedMockitoExtension)) {
            return new MockitoFastUnitFactory();
        }
        if (Arrays.stream(clazz.getDeclaredAnnotations()).anyMatch(this::isSupportedMockkExtension)) {
            return new MockkFastUnitFactory(this.mockOperations);
        }
        return new BasicFastUnitFactory();
    }

    private boolean disabledAtClassLevel(Class<?> clazz) {
        return clazz.isAnnotationPresent(Disabled.class);
    }

    private boolean hasUnsupportedNestedClass(Class<?> clazz) {
        for (Class<?> each : clazz.getDeclaredClasses()) {
            if (!this.notSuitable(each)) continue;
            return true;
        }
        return false;
    }

    private boolean hasFieldWithUnsupportedAnnotation(ReflectionClass reflect) {
        return reflect.fieldAnnotations().stream().anyMatch(a -> !SUPPORTED_FIELD_ANNOTATIONS.contains(a.annotationType().getName()));
    }

    private boolean methodHasParams(List<Method> testMethods) {
        return testMethods.stream().filter(m -> m.getParameters().length != 0).findAny().isPresent();
    }

    private boolean notSuitable(Class<?> clazz) {
        if (Arrays.stream(clazz.getAnnotations()).anyMatch(this::unsupportedAnnotation)) {
            return true;
        }
        return Reflection.allMethods(clazz).stream().anyMatch(this.hasAnnotationMatching(this::unsupportedAnnotation));
    }

    private boolean isAbstractOrSynthetic(Class<?> clazz) {
        return this.isAbstract(clazz) || clazz.isSynthetic();
    }

    private boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    private boolean unsupportedAnnotation(Annotation a) {
        return this.isUnsupportedMockkAnnotation(a) || this.isRelevantAnnotation(a) && !a.annotationType().getName().equals(MOCKITO_SETTINGS) && !this.isSupportedMockitoExtension(a) && !this.isSupportedMockkExtension(a) && !SUPPORTED_ANNOTATIONS.contains(a.annotationType());
    }

    private boolean isUnsupportedMockkAnnotation(Annotation a) {
        return a.annotationType().getName().endsWith("MockKExtension$ConfirmVerification");
    }

    private boolean isSupportedMockitoExtension(Annotation a) {
        return a.annotationType().isAssignableFrom(ExtendWith.class) && Arrays.stream(((ExtendWith)a).value()).allMatch(extension -> extension.getName().equals(MOCKITO_EXTENSION));
    }

    private boolean isSupportedMockkExtension(Annotation a) {
        return a.annotationType().isAssignableFrom(ExtendWith.class) && Arrays.stream(((ExtendWith)a).value()).allMatch(extension -> extension.getName().equals(MOCKK_EXTENSION));
    }

    private boolean isRelevantAnnotation(Annotation a) {
        return this.isJunit5Annotation(a) || Arrays.stream(a.annotationType().getAnnotations()).anyMatch(this::isJunit5Annotation);
    }

    private boolean isJunit5Annotation(Annotation a) {
        String name = a.annotationType().getName();
        return name.startsWith("org.junit.jupiter.api.");
    }

    private Predicate<Method> hasAnnotation(Class<? extends Annotation> clazz) {
        return m -> m.isAnnotationPresent(clazz);
    }

    private Predicate<Method> hasAnnotationMatching(Predicate<Annotation> f) {
        return m -> Arrays.stream(m.getAnnotations()).anyMatch(f);
    }

    private Predicate<Method> hasEnabledTestAnnotation(Class<?> clazz) {
        List<String> classLevelTags = this.allTagValues(clazz);
        return this.hasAnnotation(Test.class).and(m -> this.matchesTags((Method)m, classLevelTags)).and(this.hasAnnotation(Disabled.class).negate());
    }

    private boolean matchesTags(Method m, List<String> classLevelTags) {
        List<String> values = this.allTagValues(m);
        values.addAll(classLevelTags);
        if (values.isEmpty() && this.includedTags.isEmpty()) {
            return true;
        }
        return this.notExcluded(values) && this.isIncluded(values);
    }

    private List<String> allTagValues(AnnotatedElement m) {
        return Stream.concat(this.tagValue(m), this.tagsValue(m)).collect(Collectors.toCollection(ArrayList::new));
    }

    private boolean isIncluded(List<String> values) {
        return values.stream().anyMatch(this::tagIsIncluded);
    }

    private boolean notExcluded(List<String> values) {
        return values.stream().noneMatch(this::tagIsExcluded);
    }

    private Stream<String> tagValue(AnnotatedElement m) {
        Tag tag = m.getDeclaredAnnotation(Tag.class);
        if (tag == null) {
            return Stream.empty();
        }
        return Stream.of(tag.value());
    }

    private Stream<String> tagsValue(AnnotatedElement m) {
        Tags tags = m.getDeclaredAnnotation(Tags.class);
        if (tags == null) {
            return Stream.empty();
        }
        return Arrays.stream(tags.value()).map(Tag::value);
    }

    private boolean tagIsIncluded(String tag) {
        return this.includedTags.isEmpty() || this.includedTags.contains(tag);
    }

    private boolean tagIsExcluded(String tag) {
        return this.excludedTags.contains(tag);
    }
}

