/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.accelerator;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import org.opentest4j.TestAbortedException;
import org.pitest.testapi.Description;
import org.pitest.testapi.ResultCollector;
import org.pitest.testapi.TestUnit;

public class FastUnit
implements TestUnit {
    private final Class<?> clazz;
    private final Method method;
    private final List<Method> befores;
    private final List<Method> afters;
    private final Description desc;

    public FastUnit(Class<?> clazz, Method method, List<Method> befores, List<Method> afters, Description desc) {
        this.clazz = clazz;
        this.method = method;
        this.befores = befores;
        this.afters = afters;
        this.desc = desc;
    }

    public void execute(ResultCollector resultCollector) {
        resultCollector.notifyStart(this.getDescription());
        try {
            Object o = this.construct();
            this.pre(o);
            try {
                this.run(o);
            }
            finally {
                this.post(o);
            }
            resultCollector.notifyEnd(this.getDescription());
        }
        catch (Throwable t) {
            Throwable cause = t.getCause();
            if (cause instanceof TestAbortedException) {
                resultCollector.notifySkipped(this.getDescription());
            }
            resultCollector.notifyEnd(this.getDescription(), cause);
        }
    }

    public Object construct() throws Exception {
        Constructor<?> ctr = this.clazz.getDeclaredConstructor(new Class[0]);
        ctr.setAccessible(true);
        return ctr.newInstance(new Object[0]);
    }

    public void run(Object instance) throws Exception {
        for (Method b : this.befores) {
            b.setAccessible(true);
            b.invoke(instance, new Object[0]);
        }
        this.method.setAccessible(true);
        this.method.invoke(instance, new Object[0]);
        for (Method b : this.afters) {
            b.setAccessible(true);
            b.invoke(instance, new Object[0]);
        }
    }

    public void pre(Object testInstance) {
    }

    public void post(Object testInstance) throws Exception {
    }

    public Description getDescription() {
        return this.desc;
    }

    public String toString() {
        return this.desc.getName();
    }
}

