/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.accelerator;

import com.groupcdg.pitest.accelerator.SubResultCollector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.opentest4j.TestAbortedException;
import org.pitest.testapi.Description;
import org.pitest.testapi.ResultCollector;
import org.pitest.testapi.TestUnit;

public class MultiFastUnit
implements TestUnit {
    private final List<TestUnit> children;
    private final List<Method> beforeAlls;
    private final List<Method> afterAlls;
    private final Description desc;

    public MultiFastUnit(List<TestUnit> children, List<Method> beforeAlls, List<Method> afterAlls, Description desc) {
        this.children = children;
        this.beforeAlls = beforeAlls;
        this.afterAlls = afterAlls;
        this.desc = desc;
    }

    public void execute(ResultCollector resultCollector) {
        resultCollector.notifyStart(this.getDescription());
        try {
            Throwable failure = this.run(this.beforeAlls);
            if (failure == null) {
                failure = this.runChildren();
                Throwable cleanupFailed = this.run(this.afterAlls);
                if (failure == null) {
                    failure = cleanupFailed;
                }
            }
            this.handleThrowable(failure, resultCollector);
        }
        catch (Throwable t) {
            Throwable cause = t.getCause();
            this.handleThrowable(cause, resultCollector);
        }
    }

    private void handleThrowable(Throwable failure, ResultCollector rc) {
        if (failure != null) {
            if (failure instanceof TestAbortedException) {
                rc.notifySkipped(this.getDescription());
            } else {
                rc.notifyEnd(this.getDescription(), failure);
            }
        } else {
            rc.notifyEnd(this.getDescription());
        }
    }

    private Throwable run(List<Method> methods) {
        Throwable lastThrowable = null;
        for (Method each : methods) {
            try {
                each.setAccessible(true);
                each.invoke(null, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                lastThrowable = ex.getTargetException();
            }
            catch (Throwable t) {
                lastThrowable = t;
            }
        }
        return lastThrowable;
    }

    private Throwable runChildren() {
        SubResultCollector sub = new SubResultCollector();
        for (TestUnit each : this.children) {
            if (sub.shouldExit()) break;
            each.execute((ResultCollector)sub);
        }
        return sub.failure();
    }

    public Description getDescription() {
        return this.desc;
    }

    public String toString() {
        return this.desc.getName();
    }
}

