/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.accelerator;

import com.groupcdg.pitest.accelerator.JUnitLikeMethodComparator;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class ReflectionClass {
    private final Class<?> clazz;

    public ReflectionClass(Class<?> clazz) {
        this.clazz = clazz;
    }

    public static ReflectionClass of(Class<?> clazz) {
        return new ReflectionClass(clazz);
    }

    private static List<Method> findAllMethodsInHierarchy(Class<?> clazz) {
        List localMethods = ReflectionClass.getDeclaredMethods(clazz).stream().filter(method -> !method.isSynthetic()).collect(Collectors.toList());
        List superclassMethods = ReflectionClass.superclassMethods(clazz).stream().filter(method -> !ReflectionClass.methodShadowedBy(method, localMethods)).collect(Collectors.toList());
        List interfaceMethods = ReflectionClass.getInterfaceMethods(clazz).stream().filter(method -> !ReflectionClass.methodShadowedBy(method, localMethods)).collect(Collectors.toList());
        ArrayList<Method> methods = new ArrayList<Method>();
        methods.addAll(superclassMethods);
        methods.addAll(interfaceMethods);
        methods.addAll(localMethods);
        return methods;
    }

    private static List<Method> getDeclaredMethods(Class<?> clazz) {
        List<Method> defaultMethods = ReflectionClass.getDefaultMethods(clazz);
        List<Method> declaredMethods = ReflectionClass.asSortedList(clazz.getDeclaredMethods());
        defaultMethods.addAll(declaredMethods);
        return defaultMethods;
    }

    private static List<Method> getDefaultMethods(Class<?> clazz) {
        List visibleDefaultMethods = Arrays.stream(clazz.getMethods()).filter(Method::isDefault).collect(ReflectionClass.asMutableList());
        if (visibleDefaultMethods.isEmpty()) {
            return visibleDefaultMethods;
        }
        return Arrays.stream(clazz.getInterfaces()).map(ReflectionClass::sortedMethods).flatMap(Collection::stream).filter(visibleDefaultMethods::contains).collect(ReflectionClass.asMutableList());
    }

    private static Collector<Method, ?, ArrayList<Method>> asMutableList() {
        return Collectors.toCollection(ArrayList::new);
    }

    private static List<Method> sortedMethods(Class<?> clazz) {
        return ReflectionClass.asSortedList(clazz.getMethods());
    }

    private static List<Method> asSortedList(Method[] methods) {
        return Arrays.stream(methods).sorted(new JUnitLikeMethodComparator()).collect(Collectors.toCollection(ArrayList::new));
    }

    private static List<Method> getInterfaceMethods(Class<?> clazz) {
        ArrayList<Method> allMethods = new ArrayList<Method>();
        for (Class<?> ifc : clazz.getInterfaces()) {
            List ownMethods = ReflectionClass.sortedMethods(ifc).stream().filter(m -> !ReflectionClass.isAbstract(m)).collect(Collectors.toList());
            List superMethods = ReflectionClass.getInterfaceMethods(ifc).stream().filter(method -> !ReflectionClass.methodShadowedBy(method, ownMethods)).collect(Collectors.toList());
            allMethods.addAll(superMethods);
            allMethods.addAll(ownMethods);
        }
        return allMethods;
    }

    private static boolean isAbstract(Member member) {
        return Modifier.isAbstract(member.getModifiers());
    }

    private static List<Method> superclassMethods(Class<?> clazz) {
        Class<?> superclass = clazz.getSuperclass();
        if (ReflectionClass.notObject(superclass)) {
            return ReflectionClass.findAllMethodsInHierarchy(superclass);
        }
        return Collections.emptyList();
    }

    private static boolean notObject(Class<?> clazz) {
        return clazz != null && clazz != Object.class;
    }

    private static boolean methodShadowedBy(Method method, List<Method> others) {
        return others.stream().anyMatch(local -> ReflectionClass.signatureIsCompatible(method, local.getName(), local.getParameterTypes()));
    }

    private static boolean signatureIsCompatible(Method candidate, String methodName, Class<?>[] paramTypes) {
        if (!methodName.equals(candidate.getName()) || paramTypes.length != candidate.getParameterCount()) {
            return false;
        }
        if (Arrays.equals(paramTypes, candidate.getParameterTypes())) {
            return true;
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> lowerType = paramTypes[i];
            Class<?> upperType = candidate.getParameterTypes()[i];
            if (upperType.isAssignableFrom(lowerType)) continue;
            return false;
        }
        return ReflectionClass.isGeneric(candidate);
    }

    private static boolean isGeneric(Method method) {
        return ReflectionClass.isGeneric(method.getGenericReturnType()) || Arrays.stream(method.getGenericParameterTypes()).anyMatch(ReflectionClass::isGeneric);
    }

    private static boolean isGeneric(Type type) {
        return type instanceof TypeVariable || type instanceof GenericArrayType;
    }

    public List<Method> methodsMatching(Predicate<Method> predicate) {
        return ReflectionClass.findAllMethodsInHierarchy(this.clazz).stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Annotation> fieldAnnotations() {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>(ReflectionClass.kotlinFieldAnnotations(this.clazz));
        ReflectionClass.allFieldAnnotations(this.clazz, annotations);
        return annotations;
    }

    private static void allFieldAnnotations(Class<?> clazz, List<Annotation> annotations) {
        List forThisClass = Arrays.stream(clazz.getDeclaredFields()).flatMap(f -> Arrays.stream(f.getAnnotations())).collect(Collectors.toList());
        annotations.addAll(forThisClass);
        Class<?> superclass = clazz.getSuperclass();
        if (ReflectionClass.notObject(superclass)) {
            ReflectionClass.allFieldAnnotations(superclass, annotations);
        }
    }

    private static List<Annotation> kotlinFieldAnnotations(Class<?> clazz) {
        return Arrays.stream(clazz.getMethods()).filter(Method::isSynthetic).filter(m -> m.getName().endsWith("$annotations")).flatMap(m -> Arrays.stream(m.getAnnotations())).collect(Collectors.toList());
    }
}

