/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.accelerator.licence;

import com.groupcdg.pitest.accelerator.licence.AcceleratorInterceptor;
import com.groupcdg.pitest.accelerator.licence.Licence;
import com.groupcdg.pitest.accelerator.licence.LicencePathFinder;
import com.groupcdg.pitest.accelerator.licence.LicenceType;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Clock;
import java.util.Collection;
import java.util.function.Predicate;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.build.InterceptorParameters;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.MutationInterceptorFactory;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.plugin.Feature;
import org.pitest.util.Glob;

public class AcceleratorInterceptorFactory
implements MutationInterceptorFactory {
    private final FileSystem fs;

    public AcceleratorInterceptorFactory() {
        this(FileSystems.getDefault());
    }

    public AcceleratorInterceptorFactory(FileSystem fs) {
        this.fs = fs;
    }

    public MutationInterceptor createInterceptor(InterceptorParameters interceptorParameters) {
        Licence licence = this.findLicence(interceptorParameters.data());
        this.failIfOnlyFoundDemoLicence(licence);
        return new AcceleratorInterceptor(AcceleratorInterceptorFactory.makeFilter(licence));
    }

    public Feature provides() {
        return Feature.named((String)"_acceleration support_").asInternalFeature().withOnByDefault(true);
    }

    public String description() {
        return "Acceleration support";
    }

    private static Predicate<ClassName> makeFilter(Licence licence) {
        Collection globs = Glob.toGlobPredicates(licence.packages());
        return c -> globs.stream().anyMatch(g -> g.test(c.asJavaName()));
    }

    private void failIfOnlyFoundDemoLicence(Licence licence) {
        if (licence.type().equals((Object)LicenceType.EVALUATION) && licence.packages().contains("com.example.*")) {
            throw new IllegalStateException("Accelerator plugin requires an Arcmutate licence");
        }
    }

    private Licence findLicence(ReportOptions data) {
        try {
            Path workingDir = this.fs.getPath("", new String[0]).toRealPath(new LinkOption[0]);
            Path reportDir = this.fs.getPath(data.getReportDir(), new String[0]).toRealPath(new LinkOption[0]);
            LicencePathFinder licenceFinder = new LicencePathFinder(workingDir, 3);
            return Licence.findAndCheckLicence(Clock.systemUTC(), reportDir, data.getProjectBase(), licenceFinder, "ACCELERATOR");
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException while looking for licence");
        }
    }
}

