/*
 * Decompiled with CFR 0.152.
 */
package com.groupcdg.pitest.accelerator.mockk;

import com.groupcdg.pitest.accelerator.FastUnit;
import com.groupcdg.pitest.accelerator.FastUnitFactory;
import com.groupcdg.pitest.accelerator.mockk.KeepMockAnnotationCheck;
import com.groupcdg.pitest.accelerator.mockk.MockkFastUnit;
import com.groupcdg.pitest.accelerator.mockk.MockkOperations;
import io.mockk.junit5.MockKExtension;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.BiFunction;
import org.pitest.testapi.Description;

public class MockkFastUnitFactory
implements FastUnitFactory {
    private final boolean alwaysKeepMocks;
    private final MockkOperations operations;
    private final BiFunction<Class<?>, Method, Boolean> keepMocksCheck;

    public MockkFastUnitFactory(MockkOperations operations) {
        this.operations = operations;
        this.alwaysKeepMocks = MockkFastUnitFactory.checkKeepMocksSystemProperty();
        this.keepMocksCheck = MockkFastUnitFactory.onlyIfAnnotationPresent();
    }

    private static BiFunction<Class<?>, Method, Boolean> onlyIfAnnotationPresent() {
        try {
            MockKExtension.class.getClassLoader().loadClass("io.mockk.junit5.MockKExtension$KeepMocks");
            return new KeepMockAnnotationCheck();
        }
        catch (ClassNotFoundException ex) {
            return (c, m) -> false;
        }
    }

    @Override
    public FastUnit makeTest(Class<?> clazz, Method method, List<Method> befores, List<Method> afters) {
        boolean keepMocks = this.alwaysKeepMocks || this.keepMocksCheck.apply(clazz, method) != false;
        return new MockkFastUnit(this.operations, keepMocks, clazz, method, befores, afters, new Description(method.getName(), clazz));
    }

    @Override
    public boolean supportsBeforeAlls() {
        return false;
    }

    private static boolean checkKeepMocksSystemProperty() {
        return System.getProperty("mockk.junit.extension.keepmocks", "false").equalsIgnoreCase("true");
    }
}

