/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.annotation.service;

import com.groupdocs.annotation.utils.Utils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.atmosphere.config.service.Disconnect;
import org.atmosphere.config.service.ManagedService;
import org.atmosphere.config.service.Message;
import org.atmosphere.config.service.Post;
import org.atmosphere.config.service.Ready;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.json.JSONException;
import org.json.JSONObject;

@ManagedService(path="/annotation")
public class AnnotationManagedService {
    private static final Logger LOGGER = Logger.getLogger(AnnotationManagedService.class.getName());

    @Ready
    public void onReady(AtmosphereResource resource) {
        LOGGER.log(Level.SEVERE, null, "atmosphere connected, browser: " + resource.getAtmosphereResourceEvent().getResource().uuid());
        try {
            AnnotationManagedService.sendMessage(new JSONObject().put("action", (Object)"checkConnection").toString());
        }
        catch (JSONException e2) {
            LOGGER.log(Level.SEVERE, null, e2.getMessage());
        }
    }

    @Disconnect
    public void onDisconnect(AtmosphereResourceEvent event) {
        if (event.isCancelled()) {
            LOGGER.log(Level.SEVERE, null, "Browser " + event.getResource().uuid() + " disconnected");
        } else if (event.isClosedByClient()) {
            LOGGER.log(Level.SEVERE, null, "Browser " + event.getResource().uuid() + " disconnected");
        }
    }

    @Post
    @Message
    public void onMessage(AtmosphereResource resource) {
        if (resource == null) {
            LOGGER.log(Level.SEVERE, null, "Atmosphere resource is null!");
        } else {
            AtmosphereRequest request = resource.getRequest();
            String body = request.body().asString();
            LOGGER.log(Level.SEVERE, null, "atmosphere message: " + body);
            try {
                JSONObject jsonObject = new JSONObject(body);
                if ("updateUUID".equalsIgnoreCase(jsonObject.getString("action"))) {
                    body = new JSONObject().put("action", (Object)"updateUUID").put("clientUUID", (Object)jsonObject.getString("clientUUID")).put("UUID", (Object)resource.uuid()).toString();
                }
            }
            catch (JSONException e2) {
                LOGGER.log(Level.SEVERE, null, e2.getMessage());
            }
            resource.getBroadcaster().broadcast((Object)body);
        }
    }

    public static boolean sendMessage(Object message) {
        Broadcaster broadcaster = BroadcasterFactory.getDefault().lookup(DefaultBroadcaster.class, (Object)"/annotation");
        if (broadcaster != null) {
            return broadcaster.broadcast(message instanceof String ? message : Utils.toJson(message)) != null;
        }
        return false;
    }
}

