/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.annotation.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.groupdocs.annotation.a.c.e;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final Gson gson = new GsonBuilder().serializeNulls().create();
    private static final Pattern templatePattern = Pattern.compile("\\$\\{(\\w+)(\\|.[^|}]*)?\\}");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String processTemplate(String templateName, Map<String, String> replaceValues) throws IOException {
        String template = null;
        InputStream is = null;
        try {
            is = Utils.class.getClassLoader().getResourceAsStream("template/" + templateName);
            if (is != null) {
                template = IOUtils.toString((InputStream)is);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        if (template != null) {
            Matcher matcher = templatePattern.matcher(template);
            while (matcher.find()) {
                String key = matcher.group(1);
                String replacement = matcher.group(2);
                String string = replacement = replacement == null || replacement.length() < 1 ? "" : replacement.substring(1);
                if (replaceValues.containsKey(key)) {
                    replacement = replaceValues.get(key);
                }
                template = template.replaceAll(Pattern.quote(matcher.group()), replacement == null ? "" : replacement);
            }
        }
        return template;
    }

    public static <T> T getObjectData(String request, Class<T> clazz) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        Object data = objectMapper.readValue(request, clazz);
        return (T)data;
    }

    public static String getBody(HttpServletRequest request) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            ServletInputStream inputStream = request.getInputStream();
            if (inputStream != null) {
                int bytesRead;
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
                char[] charBuffer = new char[128];
                while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                }
            } else {
                stringBuilder.append(new String());
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        String body = stringBuilder.toString();
        return body;
    }

    public static String toJson(Object obj) {
        return gson.toJson(obj).replaceAll("\"null\"", "null");
    }

    public static <T> T fromJson(String jsonString, Class<T> clazz) {
        return (T)gson.fromJson(jsonString, clazz);
    }

    public static <T extends e> T assetEntity(T t) throws NullPointerException {
        Utils.assetEntity(t, "Object is null");
        return t;
    }

    public static <T extends e> T assetEntity(T t, String errorMessage) throws NullPointerException {
        if (t == null || t.a() == null) {
            throw new NullPointerException(errorMessage);
        }
        return t;
    }

    public static String dt2s(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return String.format(Locale.US, "%4d-%2d-%2d %d:%d:%d", cal.get(5), cal.get(2), cal.get(1), cal.get(10), cal.get(12), cal.get(13));
    }

    public static Date s2dt(String strDate) {
        return Utils.s2dt(strDate, "yyyy-MM-dd HH:mm:ss");
    }

    public static Date s2dt(String strDate, String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        try {
            return sdf.parse(strDate);
        }
        catch (ParseException e2) {
            return null;
        }
        catch (NullPointerException e3) {
            return null;
        }
    }

    public static String decodeData(String data) {
        return new String(Base64.decodeBase64((byte[])data.replaceAll(" ", "+").getBytes())).trim();
    }

    public static String encodeData(String data) {
        return new String(Base64.encodeBase64((byte[])data.getBytes(), (boolean)false)).trim();
    }

    public static void closeStreams(Object ... streams) {
        for (Object obj : streams) {
            try {
                if (obj == null) continue;
                if (obj instanceof InputStream) {
                    ((InputStream)obj).close();
                    continue;
                }
                if (obj instanceof OutputStream) {
                    ((OutputStream)obj).close();
                    continue;
                }
                Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, null, "Object '" + obj + "' can't be closed!");
            }
            catch (Exception e2) {
                Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, null, e2);
            }
        }
    }

    public static long utcToLocal(long utcTime) {
        return new Date(utcTime + (long)TimeZone.getDefault().getOffset(System.currentTimeMillis())).getTime();
    }

    public static String makeAppPath(HttpServletRequest request) {
        return request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + (request.getContextPath() == null || request.getContextPath().isEmpty() || !request.getContextPath().endsWith("/") ? "/" : "");
    }
}

