$(function () {
    "use strict";

    if (!window.console){
        window.console = { log: function(val){/* mock for IE */} }
    }
    window.jQuery.connection = {
        hub: {
            id: null, // TODO:
            qs: null,
            start: function () {
                // Initialize function
                var socket = atmosphere;
                var transport = 'websocket';
                // We are now ready to cut the request
                var request = {
                    url: window.baseUrl + 'annotation',
                    contentType: "application/json",
                    logLevel: 'debug',
                    transport: transport,
                    trackMessageLength: true,
                    reconnectInterval: 5000,
                    enableXDR: true,
                    timeout: 60000
                };

                request.onOpen = function (response) {
                    console.log('Atmosphere connected using ' + response.transport);
                    transport = response.transport;
                    // Carry the UUID. This is required if you want to call subscribe(request) again.
                    request.uuid = response.request.uuid;
                    // Connection established
                    if (window.jQuery.connection.annotationHub.established != null) {
                        window.jQuery.connection.annotationHub.established();
                    }
                };

                request.onClientTimeout = function (r) {
                    console.log('Client closed the connection after a timeout. Reconnecting in ' + request.reconnectInterval);
                    setTimeout(function () {
                        window.jQuery.connection.subSocket = socket.subscribe(request);
                    }, request.reconnectInterval);
                };

                request.onReopen = function (response) {
                    console.log('Atmosphere re-connected using ' + response.transport);
                };

                // For demonstration of how you can customize the fallbackTransport using the onTransportFailure function
                request.onTransportFailure = function (errorMsg, request) {
                    atmosphere.util.info(errorMsg);
                    request.fallbackTransport = "long-polling";
                    console.log('Atmosphere Chat. Default transport is WebSocket, fallback is ' + request.fallbackTransport);
                };

                // Incoming message
                request.onMessage = function (response) {
                    var message = response.responseBody;
                    try {
                        var json = atmosphere.util.parseJSON(message);
                        if (window.jQuery.connection && window.jQuery.connection.onMessage && response.status == 200) {
                            window.jQuery.connection.onMessage(json);
                        } else {
                            console.log('Atmosphere incoming message status: ' + response.status);
                        }
                    } catch (e) {
                        console.log('This doesn\'t look like a valid JSON: ', message);
                    }
                };

                request.onClose = function (response) {
                    console.log('Server closed the connection after a timeout');
                };

                request.onError = function (response) {
                    console.log('Sorry, but there\'s some problem with your socket or the server is down');
                };

                request.onReconnect = function (request, response) {
                    console.log('Connection lost, trying to reconnect. Trying to reconnect ' + request.reconnectInterval);
                };
                window.jQuery.connection.subSocket = socket.subscribe(request);

                window.jQuery.connection.onMessage = function (jsonObj) {
                    if (window.jQuery.connection.annotationHub.callers.hasOwnProperty(jsonObj.action)) {
                        window.jQuery.connection.annotationHub.callers[jsonObj.action](jsonObj.action, jsonObj);
                    }
                };
                window.jQuery.connection._clientUUID = (function (a, b) {
                    return function () {
                        return "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(a, b).toUpperCase()
                    }
                }(/[xy]/g, function (b) {
                    var a = Math.random() * 16 | 0, d = b == "x" ? a : a & 3 | 8;
                    return d.toString(16)
                }))();
                return window.jQuery.connection.annotationHub;
            }
        },
        annotationHub: {
            established: null,
            client: {},
            callers: {
                checkConnection: function (action, data) {
                    window.jQuery.connection.subSocket.push({
                        // You should send JSON STRING in field 'data'
                        data: JSON.stringify({
                            action: 'updateUUID',
                            clientUUID: window.jQuery.connection._clientUUID
                        })
                    });
                },
                updateUUID: function (action, data) {
                    if (window.jQuery.connection._clientUUID == data.clientUUID) {
                        window.jQuery.connection.hub.id = data.UUID;
                    }
                },
                createAnnotationOnClient: function (action, data) {
                    if (data.documentGuid == window.jQuery.connection.annotationHub.server.fileId) {
                        window.jQuery.connection.annotationHub.client[action](data.UUID, data);
                    }
                },
                createReplyOnClient: function (action, data) {
                    window.jQuery.connection.annotationHub.client[action](data.UUID, data);
                },
                deleteAnnotationOnClient: function (action, data) {
                    window.jQuery.connection.annotationHub.client[action](data.UUID, data.annotationGuid);
                },
                deleteAnnotationReplyOnClient: function (action, data) {
                    window.jQuery.connection.annotationHub.client[action](data.UUID, data.annotationGuid, data.replyGuid, data.childReplies);
                },
                editAnnotationReplyOnClient: function (action, data) {
                    window.jQuery.connection.annotationHub.client[action](data.UUID, data.annotationGuid, data.replyGuid, data.newText);
                },
                moveAnnotationMarkerOnClient: function (action, data) {
                    window.jQuery.connection.annotationHub.client[action](data.UUID, data.annotationGuid, data.position, data.data);
                },
                moveAnnotationOnClient: function (action, data) {
                },
                resizeAnnotationOnClient: function (action, data) {
                    window.jQuery.connection.annotationHub.client[action](data.UUID, data.annotationGuid, data.width, data.height);
                },
                setAnnotationAccessOnClient: function (action, data) {
                },
                setReviewersColorsOnClient: function (action, data) {
                },
                setTextFieldColorOnClient: function (action, data) {
                    window.jQuery.connection.annotationHub.client[action](data.UUID, data.annotationGuid, data.color);
                },
                updateTextFieldOnClient: function (action, data) {
                    window.jQuery.connection.annotationHub.client[action](data.UUID, data.annotationGuid, data.newText, data.fontFamily, data.fontSize);
                }
            },
            server: {
                fileId: null,
                setDocumentGuidForConnection: function (fileId) {
                    window.jQuery.connection.annotationHub.server.fileId = fileId;
                }
            },
            done: function (established) {
                window.jQuery.connection.annotationHub.established = established;

            }
        }
    };
});
