/*
 * Decompiled with CFR 0.152.
 */
package com.groupon.uuid;

import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;

public class UUID {
    public static final int PID = UUID.processId();
    public static final byte[] MAC = UUID.macAddress();
    private static final int MAX_PID = 65536;
    private static final int INCREMENT = 198491317;
    private static final char VERSION = 'b';
    private static final int VERSION_DEC = UUID.mapToByte('b', '0');
    private static final AtomicInteger COUNTER = new AtomicInteger(new Random(System.nanoTime()).nextInt());
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static boolean sequential = false;
    protected final byte[] content;

    public UUID() {
        long time = new Date().getTime();
        this.content = new byte[16];
        if (!sequential) {
            int count = COUNTER.addAndGet(198491317);
            this.content[0] = (byte)((count & 0xF) << 4 | (count & 0xF0) >> 4);
            this.content[1] = (byte)((count & 0xF00) >> 4 | (count & 0xF000) >> 12);
            this.content[2] = (byte)((count & 0xF0000) >> 12 | (count & 0xF00000) >> 20);
            this.content[3] = (byte)((count & 0xF000000) >> 20 | (count & 0xF0000000) >> 28);
        } else {
            int count = COUNTER.addAndGet(1);
            this.content[0] = (byte)(count >> 24);
            this.content[1] = (byte)(count >> 16);
            this.content[2] = (byte)(count >> 8);
            this.content[3] = (byte)count;
        }
        this.content[4] = (byte)(PID >> 8);
        this.content[5] = (byte)PID;
        this.content[6] = (byte)(VERSION_DEC | 0xF & MAC[2]);
        this.content[7] = MAC[3];
        this.content[8] = MAC[4];
        this.content[9] = MAC[5];
        this.content[10] = (byte)(time >> 40);
        this.content[11] = (byte)(time >> 32);
        this.content[12] = (byte)(time >> 24);
        this.content[13] = (byte)(time >> 16);
        this.content[14] = (byte)(time >> 8);
        this.content[15] = (byte)time;
    }

    public UUID(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("Tried to construct UUID with null byte array");
        }
        if (bytes.length != 16) {
            throw new IllegalArgumentException("Attempted to parse malformed UUID: " + Arrays.toString(bytes));
        }
        this.content = Arrays.copyOf(bytes, 16);
    }

    public UUID(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Tried to construct UUID from null String");
        }
        char[] chars = (id = id.trim()).toCharArray();
        if (!UUID.isValidUUID(chars)) {
            throw new IllegalArgumentException("Attempted to parse malformed UUID: " + id);
        }
        this.content = new byte[16];
        this.content[0] = UUID.mapToByte(chars[0], chars[1]);
        this.content[1] = UUID.mapToByte(chars[2], chars[3]);
        this.content[2] = UUID.mapToByte(chars[4], chars[5]);
        this.content[3] = UUID.mapToByte(chars[6], chars[7]);
        this.content[4] = UUID.mapToByte(chars[9], chars[10]);
        this.content[5] = UUID.mapToByte(chars[11], chars[12]);
        this.content[6] = UUID.mapToByte(chars[14], chars[15]);
        this.content[7] = UUID.mapToByte(chars[16], chars[17]);
        this.content[8] = UUID.mapToByte(chars[19], chars[20]);
        this.content[9] = UUID.mapToByte(chars[21], chars[22]);
        this.content[10] = UUID.mapToByte(chars[24], chars[25]);
        this.content[11] = UUID.mapToByte(chars[26], chars[27]);
        this.content[12] = UUID.mapToByte(chars[28], chars[29]);
        this.content[13] = UUID.mapToByte(chars[30], chars[31]);
        this.content[14] = UUID.mapToByte(chars[32], chars[33]);
        this.content[15] = UUID.mapToByte(chars[34], chars[35]);
    }

    public UUID(java.util.UUID uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("Tried to construct Locality UUID with null java.util.UUID");
        }
        this.content = new byte[16];
        this.constructFromLongs(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    public UUID(long mostSigBits, long leastSigBits) {
        this.content = new byte[16];
        this.constructFromLongs(mostSigBits, leastSigBits);
    }

    private void constructFromLongs(long hi, long lo) {
        this.content[0] = (byte)(hi >> 56);
        this.content[1] = (byte)(hi >> 48);
        this.content[2] = (byte)(hi >> 40);
        this.content[3] = (byte)(hi >> 32);
        this.content[4] = (byte)(hi >> 24);
        this.content[5] = (byte)(hi >> 16);
        this.content[6] = (byte)(hi >> 8);
        this.content[7] = (byte)hi;
        this.content[8] = (byte)(lo >> 56);
        this.content[9] = (byte)(lo >> 48);
        this.content[10] = (byte)(lo >> 40);
        this.content[11] = (byte)(lo >> 32);
        this.content[12] = (byte)(lo >> 24);
        this.content[13] = (byte)(lo >> 16);
        this.content[14] = (byte)(lo >> 8);
        this.content[15] = (byte)lo;
    }

    public static boolean isValidUUID(String id) {
        return id != null && UUID.isValidUUID(id.toCharArray());
    }

    public static boolean isValidUUID(char[] ch) {
        return ch != null && ch.length == 36 && UUID.validHex(ch[0]) && UUID.validHex(ch[1]) && UUID.validHex(ch[2]) && UUID.validHex(ch[3]) && UUID.validHex(ch[4]) && UUID.validHex(ch[5]) && UUID.validHex(ch[6]) && UUID.validHex(ch[7]) && ch[8] == '-' && UUID.validHex(ch[9]) && UUID.validHex(ch[10]) && UUID.validHex(ch[11]) && UUID.validHex(ch[12]) && ch[13] == '-' && UUID.validHex(ch[14]) && UUID.validHex(ch[15]) && UUID.validHex(ch[16]) && UUID.validHex(ch[17]) && ch[18] == '-' && UUID.validHex(ch[19]) && UUID.validHex(ch[20]) && UUID.validHex(ch[21]) && UUID.validHex(ch[22]) && ch[23] == '-' && UUID.validHex(ch[24]) && UUID.validHex(ch[25]) && UUID.validHex(ch[26]) && UUID.validHex(ch[27]) && UUID.validHex(ch[28]) && UUID.validHex(ch[29]) && UUID.validHex(ch[30]) && UUID.validHex(ch[31]) && UUID.validHex(ch[32]) && UUID.validHex(ch[33]) && UUID.validHex(ch[34]) && UUID.validHex(ch[35]);
    }

    private static boolean validHex(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public static void useSequentialIds() {
        if (!sequential) {
            byte[] digest;
            TimeZone tz = TimeZone.getTimeZone("UTC");
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmm");
            df.setTimeZone(tz);
            String date = df.format(new Date()).substring(0, 11);
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                digest = md.digest(date.getBytes("UTF-8"));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create hash of date for the sequential counter", e);
            }
            int x = digest[0] & 0xFF;
            x |= (digest[1] & 0xFF) << 8;
            x |= (digest[2] & 0xFF) << 16;
            COUNTER.set(x |= (digest[3] & 0xFF) << 24);
        }
        sequential = true;
    }

    public static void useVariableIds() {
        sequential = false;
    }

    private static int intValue(char x) {
        if (x >= '0' && x <= '9') {
            return x - 48;
        }
        if (x >= 'a' && x <= 'f') {
            return x - 97 + 10;
        }
        if (x >= 'A' && x <= 'F') {
            return x - 65 + 10;
        }
        throw new RuntimeException("Error parsing UUID at character: " + x);
    }

    private static byte mapToByte(char a, char b) {
        int ai = UUID.intValue(a);
        int bi = UUID.intValue(b);
        return (byte)(ai << 4 | bi);
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this.content, 16);
    }

    public String toString() {
        char[] id = new char[]{HEX[(this.content[0] & 0xF0) >> 4], HEX[this.content[0] & 0xF], HEX[(this.content[1] & 0xF0) >> 4], HEX[this.content[1] & 0xF], HEX[(this.content[2] & 0xF0) >> 4], HEX[this.content[2] & 0xF], HEX[(this.content[3] & 0xF0) >> 4], HEX[this.content[3] & 0xF], '-', HEX[(this.content[4] & 0xF0) >> 4], HEX[this.content[4] & 0xF], HEX[(this.content[5] & 0xF0) >> 4], HEX[this.content[5] & 0xF], '-', HEX[(this.content[6] & 0xF0) >> 4], HEX[this.content[6] & 0xF], HEX[(this.content[7] & 0xF0) >> 4], HEX[this.content[7] & 0xF], '-', HEX[(this.content[8] & 0xF0) >> 4], HEX[this.content[8] & 0xF], HEX[(this.content[9] & 0xF0) >> 4], HEX[this.content[9] & 0xF], '-', HEX[(this.content[10] & 0xF0) >> 4], HEX[this.content[10] & 0xF], HEX[(this.content[11] & 0xF0) >> 4], HEX[this.content[11] & 0xF], HEX[(this.content[12] & 0xF0) >> 4], HEX[this.content[12] & 0xF], HEX[(this.content[13] & 0xF0) >> 4], HEX[this.content[13] & 0xF], HEX[(this.content[14] & 0xF0) >> 4], HEX[this.content[14] & 0xF], HEX[(this.content[15] & 0xF0) >> 4], HEX[this.content[15] & 0xF]};
        return new String(id);
    }

    public long getMostSignificantBits() {
        long a = ((long)this.content[0] & 0xFFL) << 56;
        a |= ((long)this.content[1] & 0xFFL) << 48;
        a |= ((long)this.content[2] & 0xFFL) << 40;
        a |= ((long)this.content[3] & 0xFFL) << 32;
        a |= ((long)this.content[4] & 0xFFL) << 24;
        a |= ((long)this.content[5] & 0xFFL) << 16;
        a |= ((long)this.content[6] & 0xFFL) << 8;
        return a |= (long)this.content[7] & 0xFFL;
    }

    public long getLeastSignificantBits() {
        long b = ((long)this.content[8] & 0xFFL) << 56;
        b |= ((long)this.content[9] & 0xFFL) << 48;
        b |= ((long)this.content[10] & 0xFFL) << 40;
        b |= ((long)this.content[11] & 0xFFL) << 32;
        b |= ((long)this.content[12] & 0xFFL) << 24;
        b |= ((long)this.content[13] & 0xFFL) << 16;
        b |= ((long)this.content[14] & 0xFFL) << 8;
        return b |= (long)this.content[15] & 0xFFL;
    }

    public java.util.UUID toJavaUUID() {
        return new java.util.UUID(this.getMostSignificantBits(), this.getLeastSignificantBits());
    }

    public char getVersion() {
        return HEX[(this.content[6] & 0xF0) >> 4];
    }

    public int getProcessId() {
        if (this.getVersion() != 'b') {
            return -1;
        }
        return (this.content[4] & 0xFF) << 8 | this.content[5] & 0xFF;
    }

    public Date getTimestamp() {
        if (this.getVersion() != 'b') {
            return null;
        }
        long time = ((long)this.content[10] & 0xFFL) << 40;
        time |= ((long)this.content[11] & 0xFFL) << 32;
        time |= ((long)this.content[12] & 0xFFL) << 24;
        time |= ((long)this.content[13] & 0xFFL) << 16;
        time |= ((long)this.content[14] & 0xFFL) << 8;
        return new Date(time |= (long)this.content[15] & 0xFFL);
    }

    public byte[] getMacFragment() {
        if (this.getVersion() != 'b') {
            return null;
        }
        byte[] x = new byte[]{0, 0, (byte)(this.content[6] & 0xF), this.content[7], this.content[8], this.content[9]};
        return x;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UUID that = (UUID)o;
        if (this.content.length != that.content.length) {
            return false;
        }
        for (int i = 0; i < this.content.length; ++i) {
            if (this.content[i] == that.content[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.content);
    }

    private static byte[] macAddress() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            byte[] mac = null;
            while (interfaces.hasMoreElements() && (mac == null || mac.length != 6)) {
                NetworkInterface netInterface = interfaces.nextElement();
                if (netInterface.isLoopback() || netInterface.isVirtual()) continue;
                mac = netInterface.getHardwareAddress();
            }
            if (mac == null) {
                mac = new byte[]{0, 0, 0, 0, 0, 0};
            }
            return mac;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get MAC address");
        }
    }

    private static int processId() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            throw new RuntimeException("Could not get PID");
        }
        try {
            return Integer.parseInt(jvmName.substring(0, index)) % 65536;
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Could not get PID");
        }
    }
}

