/*
 * Decompiled with CFR 0.152.
 */
package com.gruelbox.transactionoutbox.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.gruelbox.transactionoutbox.Invocation;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CustomInvocationDeserializer
extends StdDeserializer<Invocation> {
    private static final Logger log = LoggerFactory.getLogger(CustomInvocationDeserializer.class);
    private static final Pattern setPattern = Pattern.compile("\\{\\w*\"(java.util.ImmutableCollections\\$Set[\\dN]+)\"\\w*:");
    private static final Pattern mapPattern = Pattern.compile("\\{\\w*\"(java.util.ImmutableCollections\\$Map[\\dN]+)\"\\w*:");
    private static final Pattern listPattern = Pattern.compile("\\{\\w*\"(java.util.ImmutableCollections\\$List[\\dN]+)\"\\w*:");

    protected CustomInvocationDeserializer(Class<?> vc) {
        super(vc);
    }

    CustomInvocationDeserializer() {
        this(Invocation.class);
    }

    public Invocation deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        String className = node.get("className").textValue();
        String methodName = node.get("methodName").textValue();
        ArrayNode paramTypes = (ArrayNode)node.get("parameterTypes");
        JsonNode arguments = node.get("args");
        JsonNode processedArguments = this.replaceImmutableCollections(arguments, p);
        Class[] types = new Class[paramTypes.size()];
        for (int i = 0; i < paramTypes.size(); ++i) {
            try {
                types[i] = ClassUtils.getClass((String)paramTypes.get(i).asText());
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        Object[] args = (Object[])p.getCodec().treeToValue((TreeNode)processedArguments, Object[].class);
        Map mdc = (Map)p.getCodec().readValue(p.getCodec().treeAsTokens((TreeNode)node.get("mdc")), (TypeReference)new TypeReference<Map<String, String>>(){});
        return new Invocation(className, methodName, types, args, mdc);
    }

    private JsonNode replaceImmutableCollections(JsonNode arguments, JsonParser p) throws IOException {
        String args = arguments.toString();
        args = setPattern.matcher(args).replaceAll("{\"java.util.HashSet\":");
        args = mapPattern.matcher(args).replaceAll("{\"java.util.HashMap\":");
        args = listPattern.matcher(args).replaceAll("{\"java.util.ArrayList\":");
        JsonParser parser = p.getCodec().getFactory().createParser(args);
        return (JsonNode)p.getCodec().readTree(parser);
    }
}

