/*
 * Decompiled with CFR 0.152.
 */
package com.gruelbox.transactionoutbox.jackson;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gruelbox.transactionoutbox.Beta;
import com.gruelbox.transactionoutbox.DefaultInvocationSerializer;
import com.gruelbox.transactionoutbox.Invocation;
import com.gruelbox.transactionoutbox.InvocationSerializer;
import com.gruelbox.transactionoutbox.jackson.TransactionOutboxJacksonModule;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

@Beta
public final class JacksonInvocationSerializer
implements InvocationSerializer {
    private final ObjectMapper mapper;
    private final InvocationSerializer defaultInvocationSerializer;

    private JacksonInvocationSerializer(ObjectMapper mapper, DefaultInvocationSerializer defaultInvocationSerializer) {
        this.mapper = mapper.copy();
        this.defaultInvocationSerializer = defaultInvocationSerializer;
        this.mapper.setDefaultTyping(TransactionOutboxJacksonModule.typeResolver());
        this.mapper.registerModule((Module)new TransactionOutboxJacksonModule());
    }

    public void serializeInvocation(Invocation invocation, Writer writer) {
        try {
            this.mapper.writeValue(writer, (Object)invocation);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Invocation deserializeInvocation(Reader reader) {
        try {
            BufferedReader br = new BufferedReader(reader);
            if (this.checkForOldSerialization(br)) {
                if (this.defaultInvocationSerializer == null) {
                    throw new UnsupportedOperationException("Can't deserialize GSON-format tasks without a " + DefaultInvocationSerializer.class.getSimpleName() + ". Supply one when building " + this.getClass().getSimpleName());
                }
                return this.defaultInvocationSerializer.deserializeInvocation((Reader)br);
            }
            return (Invocation)this.mapper.readValue((Reader)br, Invocation.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean checkForOldSerialization(BufferedReader reader) throws IOException {
        reader.mark(1);
        char[] chars = new char[6];
        int charsRead = reader.read(chars, 0, 6);
        String result = "";
        if (charsRead != -1) {
            result = new String(chars, 0, charsRead);
        }
        reader.reset();
        return result.startsWith("{\"c\":");
    }

    public static JacksonInvocationSerializerBuilder builder() {
        return new JacksonInvocationSerializerBuilder();
    }

    public static class JacksonInvocationSerializerBuilder {
        private ObjectMapper mapper;
        private DefaultInvocationSerializer defaultInvocationSerializer;

        JacksonInvocationSerializerBuilder() {
        }

        public JacksonInvocationSerializerBuilder mapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public JacksonInvocationSerializerBuilder defaultInvocationSerializer(DefaultInvocationSerializer defaultInvocationSerializer) {
            this.defaultInvocationSerializer = defaultInvocationSerializer;
            return this;
        }

        public JacksonInvocationSerializer build() {
            return new JacksonInvocationSerializer(this.mapper, this.defaultInvocationSerializer);
        }

        public String toString() {
            return "JacksonInvocationSerializer.JacksonInvocationSerializerBuilder(mapper=" + this.mapper + ", defaultInvocationSerializer=" + this.defaultInvocationSerializer + ")";
        }
    }
}

