/*
 * Decompiled with CFR 0.152.
 */
package com.gruelbox.transactionoutbox.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.gruelbox.transactionoutbox.Invocation;
import com.gruelbox.transactionoutbox.TransactionOutboxEntry;
import java.io.IOException;
import java.time.Instant;
import java.util.Map;

class TransactionOutboxEntryDeserializer
extends JsonDeserializer<TransactionOutboxEntry> {
    TransactionOutboxEntryDeserializer() {
    }

    public TransactionOutboxEntry deserialize(JsonParser p, DeserializationContext c) throws IOException {
        ObjectCodec oc = p.getCodec();
        JsonNode node = (JsonNode)oc.readTree(p);
        JsonNode i = node.get("invocation");
        JsonNode mdc = i.get("mdc");
        return TransactionOutboxEntry.builder().id(node.get("id").asText()).lastAttemptTime(this.mapJsonInstant(node, "lastAttemptTime", c)).nextAttemptTime(this.mapJsonInstant(node, "nextAttemptTime", c)).attempts(node.get("attempts").asInt()).blocked(node.get("blocked").asBoolean()).processed(node.get("processed").asBoolean()).uniqueRequestId(this.mapJsonNull(node.get("uniqueRequestId"), JsonNode::asText)).version(node.get("version").asInt()).invocation(new Invocation(i.get("className").asText(), i.get("methodName").asText(), (Class[])c.readTreeAsValue(i.get("parameterTypes"), Class[].class), (Object[])c.readTreeAsValue(i.get("args"), Object[].class), mdc.isNull() ? null : (Map)c.readTreeAsValue(mdc, c.getTypeFactory().constructType((TypeReference)new TypeReference<Map<String, String>>(){})))).build();
    }

    private Instant mapJsonInstant(JsonNode node, String nextAttemptTime, DeserializationContext c) throws IOException {
        return this.mapJsonNull(node.get(nextAttemptTime), n -> (Instant)c.readTreeAsValue(n, Instant.class));
    }

    private <T> T mapJsonNull(JsonNode jsonNode, JsonThrowingFunction<JsonNode, T> fn) throws IOException {
        if (jsonNode == null) {
            return null;
        }
        if (jsonNode.isNull()) {
            return null;
        }
        return fn.apply(jsonNode);
    }

    @FunctionalInterface
    private static interface JsonThrowingFunction<T, U> {
        public U apply(T var1) throws IOException;
    }
}

