/*
 * Decompiled with CFR 0.152.
 */
package com.gruelbox.transactionoutbox;

import com.gruelbox.transactionoutbox.Beta;
import com.gruelbox.transactionoutbox.NoTransactionActiveException;
import com.gruelbox.transactionoutbox.ThreadLocalContextTransactionManager;
import com.gruelbox.transactionoutbox.ThrowingTransactionalSupplier;
import com.gruelbox.transactionoutbox.ThrowingTransactionalWork;
import com.gruelbox.transactionoutbox.Transaction;
import com.gruelbox.transactionoutbox.TransactionalSupplier;
import com.gruelbox.transactionoutbox.TransactionalWork;
import com.gruelbox.transactionoutbox.Utils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Beta
@Service
public class SpringTransactionManager
implements ThreadLocalContextTransactionManager {
    private static final Logger log = LoggerFactory.getLogger(SpringTransactionManager.class);
    private final SpringTransaction transactionInstance = new SpringTransaction();
    private final DataSource dataSource;

    @Autowired
    SpringTransactionManager(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void inTransaction(Runnable runnable) {
        Utils.uncheck(() -> this.inTransactionReturnsThrows(ThrowingTransactionalSupplier.fromRunnable((Runnable)runnable)));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void inTransaction(TransactionalWork work) {
        Utils.uncheck(() -> this.inTransactionReturnsThrows(ThrowingTransactionalSupplier.fromWork((TransactionalWork)work)));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public <T> T inTransactionReturns(TransactionalSupplier<T> supplier) {
        return (T)Utils.uncheckedly(() -> this.inTransactionReturnsThrows(ThrowingTransactionalSupplier.fromSupplier((TransactionalSupplier)supplier)));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public <E extends Exception> void inTransactionThrows(ThrowingTransactionalWork<E> work) throws E {
        this.inTransactionReturnsThrows(ThrowingTransactionalSupplier.fromWork(work));
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public <T, E extends Exception> T inTransactionReturnsThrows(ThrowingTransactionalSupplier<T, E> work) throws E {
        return (T)work.doWork((Transaction)this.transactionInstance);
    }

    public <T, E extends Exception> T requireTransactionReturns(ThrowingTransactionalSupplier<T, E> work) throws E, NoTransactionActiveException {
        if (!TransactionSynchronizationManager.isActualTransactionActive()) {
            throw new NoTransactionActiveException();
        }
        return (T)work.doWork((Transaction)this.transactionInstance);
    }

    private final class SpringTransaction
    implements Transaction {
        private SpringTransaction() {
        }

        public Connection connection() {
            return DataSourceUtils.getConnection((DataSource)SpringTransactionManager.this.dataSource);
        }

        public PreparedStatement prepareBatchStatement(String sql) {
            final BatchCountingStatement preparedStatement = (BatchCountingStatement)Utils.uncheckedly(() -> BatchCountingStatementHandler.countBatches(this.connection().prepareStatement(sql)));
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void beforeCommit(boolean readOnly) {
                    if (preparedStatement.getBatchCount() != 0) {
                        log.debug("Flushing batches");
                        Utils.uncheck(preparedStatement::executeBatch);
                    }
                }

                public void afterCompletion(int status) {
                    Utils.safelyClose((AutoCloseable[])new AutoCloseable[]{preparedStatement});
                }
            });
            return preparedStatement;
        }

        public void addPostCommitHook(final Runnable runnable) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    runnable.run();
                }
            });
        }
    }

    private static final class BatchCountingStatementHandler
    implements InvocationHandler {
        private final PreparedStatement delegate;
        private int count = 0;

        private BatchCountingStatementHandler(PreparedStatement delegate) {
            this.delegate = delegate;
        }

        static BatchCountingStatement countBatches(PreparedStatement delegate) {
            return (BatchCountingStatement)Proxy.newProxyInstance(BatchCountingStatementHandler.class.getClassLoader(), new Class[]{BatchCountingStatement.class}, (InvocationHandler)new BatchCountingStatementHandler(delegate));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("getBatchCount".equals(method.getName())) {
                return this.count;
            }
            try {
                Object object = method.invoke((Object)this.delegate, args);
                return object;
            }
            finally {
                if ("addBatch".equals(method.getName())) {
                    ++this.count;
                }
            }
        }
    }

    private static interface BatchCountingStatement
    extends PreparedStatement {
        public int getBatchCount();
    }
}

