/*
 * Decompiled with CFR 0.152.
 */
package net.oauth;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthException;
import net.oauth.OAuthProblemException;
import net.oauth.OAuthValidator;
import net.oauth.signature.OAuthSignatureMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthMessage {
    public String method;
    public String URL;
    private final List<Map.Entry<String, String>> parameters;
    private Map<String, String> parameterMap;
    private boolean parametersAreComplete = false;
    public static final String HTTP_REQUEST = "HTTP request";
    public static final String HTTP_RESPONSE = "HTTP response";
    public static final String AUTH_SCHEME = "OAuth";
    static final Pattern AUTHORIZATION = Pattern.compile("\\s*(\\w*)\\s+(.*)");
    static final Pattern NVP = Pattern.compile("(\\S*)\\s*\\=\\s*\"([^\"]*)\"");
    protected static final byte[] NO_BYTES = new byte[0];
    protected static final List<Map.Entry> NO_PARAMETERS = Collections.emptyList();
    protected static final String DEFAULT_CHARSET = "ISO-8859-1";
    private static final Pattern CHARSET = Pattern.compile("; *charset *= *([^;\"]*|\"([^\"]|\\\\\")*\")(;|$)");

    public OAuthMessage(String method, String URL2, Collection<? extends Map.Entry> parameters) {
        this.method = method;
        this.URL = URL2;
        if (parameters == null) {
            this.parameters = new ArrayList<Map.Entry<String, String>>();
        } else {
            this.parameters = new ArrayList<Map.Entry<String, String>>(parameters.size());
            for (Map.Entry entry : parameters) {
                this.parameters.add(new OAuth.Parameter(OAuthMessage.toString(entry.getKey()), OAuthMessage.toString(entry.getValue())));
            }
        }
    }

    public String toString() {
        return "OAuthMessage(" + this.method + ", " + this.URL + ", " + this.parameters + ")";
    }

    private void beforeGetParameter() throws IOException {
        if (!this.parametersAreComplete) {
            this.completeParameters();
            this.parametersAreComplete = true;
        }
    }

    protected void completeParameters() throws IOException {
    }

    public List<Map.Entry<String, String>> getParameters() throws IOException {
        this.beforeGetParameter();
        return Collections.unmodifiableList(this.parameters);
    }

    public void addParameter(String key, String value) {
        this.addParameter(new OAuth.Parameter(key, value));
    }

    public void addParameter(Map.Entry<String, String> parameter) {
        this.parameters.add(parameter);
        this.parameterMap = null;
    }

    public void addParameters(Collection<? extends Map.Entry<String, String>> parameters) {
        this.parameters.addAll(parameters);
        this.parameterMap = null;
    }

    public String getParameter(String name) throws IOException {
        return this.getParameterMap().get(name);
    }

    public String getConsumerKey() throws IOException {
        return this.getParameter("oauth_consumer_key");
    }

    public String getToken() throws IOException {
        return this.getParameter("oauth_token");
    }

    public String getSignatureMethod() throws IOException {
        return this.getParameter("oauth_signature_method");
    }

    public String getSignature() throws IOException {
        return this.getParameter("oauth_signature");
    }

    protected Map<String, String> getParameterMap() throws IOException {
        this.beforeGetParameter();
        if (this.parameterMap == null) {
            this.parameterMap = OAuth.newMap(this.parameters);
        }
        return this.parameterMap;
    }

    public String getContentType() {
        return null;
    }

    public String getContentCharset() {
        Matcher m;
        String contentType = this.getContentType();
        if (contentType != null && (m = CHARSET.matcher(contentType)).find()) {
            String charset = m.group(1);
            if (charset.length() >= 2 && charset.charAt(0) == '\"' && charset.charAt(charset.length() - 1) == '\"') {
                charset = charset.substring(1, charset.length() - 1);
                charset = charset.replace("\\\"", "\"");
            }
            return charset;
        }
        return DEFAULT_CHARSET;
    }

    public String getBodyAsString() throws IOException {
        return null;
    }

    public InputStream getBodyAsStream() throws IOException {
        String body = this.getBodyAsString();
        return body == null ? null : new ByteArrayInputStream(body.getBytes(this.getContentCharset()));
    }

    public Map<String, Object> getDump() throws IOException {
        HashMap<String, Object> into = new HashMap<String, Object>();
        this.dump(into);
        return into;
    }

    protected void dump(Map<String, Object> into) throws IOException {
        into.put("URL", this.URL);
        try {
            into.putAll(this.getParameterMap());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void requireParameters(String ... names) throws OAuthProblemException, IOException {
        Set<String> present = this.getParameterMap().keySet();
        ArrayList<String> absent = new ArrayList<String>();
        for (String required : names) {
            if (present.contains(required)) continue;
            absent.add(required);
        }
        if (!absent.isEmpty()) {
            OAuthProblemException problem = new OAuthProblemException("parameter_absent");
            problem.setParameter("oauth_parameters_absent", OAuth.percentEncode(absent));
            throw problem;
        }
    }

    public void addRequiredParameters(OAuthAccessor accessor) throws OAuthException, IOException, URISyntaxException {
        String signatureMethod;
        Map<String, String> pMap = OAuth.newMap(this.parameters);
        if (pMap.get("oauth_token") == null && accessor.accessToken != null) {
            this.addParameter("oauth_token", accessor.accessToken);
        }
        OAuthConsumer consumer = accessor.consumer;
        if (pMap.get("oauth_consumer_key") == null) {
            this.addParameter("oauth_consumer_key", consumer.consumerKey);
        }
        if ((signatureMethod = pMap.get("oauth_signature_method")) == null) {
            signatureMethod = (String)consumer.getProperty("oauth_signature_method");
            if (signatureMethod == null) {
                signatureMethod = "HMAC-SHA1";
            }
            this.addParameter("oauth_signature_method", signatureMethod);
        }
        if (pMap.get("oauth_timestamp") == null) {
            this.addParameter("oauth_timestamp", System.currentTimeMillis() / 1000L + "");
        }
        if (pMap.get("oauth_nonce") == null) {
            this.addParameter("oauth_nonce", System.nanoTime() + "");
        }
        if (pMap.get("oauth_version") == null) {
            this.addParameter("oauth_version", "1.0");
        }
        this.sign(accessor);
    }

    public void sign(OAuthAccessor accessor) throws IOException, OAuthException, URISyntaxException {
        OAuthSignatureMethod.newSigner(this, accessor).sign(this);
    }

    public void validateMessage(OAuthAccessor accessor, OAuthValidator validator) throws OAuthException, IOException, URISyntaxException {
        validator.validateMessage(this, accessor);
    }

    public void validateSignature(OAuthAccessor accessor) throws OAuthException, IOException, URISyntaxException {
        OAuthSignatureMethod.newSigner(this, accessor).validate(this);
    }

    public String getAuthorizationHeader(String realm) throws IOException {
        StringBuilder into = new StringBuilder(AUTH_SCHEME);
        into.append(" realm=\"").append(OAuth.percentEncode(realm)).append('\"');
        this.beforeGetParameter();
        if (this.parameters != null) {
            for (Map.Entry<String, String> parameter : this.parameters) {
                String name = OAuthMessage.toString(parameter.getKey());
                if (!name.startsWith("oauth_")) continue;
                into.append(", ");
                into.append(OAuth.percentEncode(name)).append("=\"").append(OAuth.percentEncode(OAuthMessage.toString(parameter.getValue()))).append('\"');
            }
        }
        return into.toString();
    }

    public static List<OAuth.Parameter> decodeAuthorization(String authorization) {
        Matcher m;
        ArrayList<OAuth.Parameter> into = new ArrayList<OAuth.Parameter>();
        if (authorization != null && (m = AUTHORIZATION.matcher(authorization)).matches() && AUTH_SCHEME.equalsIgnoreCase(m.group(1))) {
            for (String nvp : m.group(2).split("\\s*,\\s*")) {
                m = NVP.matcher(nvp);
                if (!m.matches()) continue;
                String name = OAuth.decodePercent(m.group(1));
                String value = OAuth.decodePercent(m.group(2));
                into.add(new OAuth.Parameter(name, value));
            }
        }
        return into;
    }

    private static final String toString(Object from) {
        return from == null ? null : from.toString();
    }
}

