/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OAuthClient {
    public static final String PARAMETER_STYLE = "parameterStyle";

    public void getRequestToken(OAuthAccessor accessor, String httpMethod) throws IOException, OAuthException, URISyntaxException {
        this.getRequestToken(accessor, httpMethod, null);
    }

    public void getRequestToken(OAuthAccessor accessor, String httpMethod, Collection<? extends Map.Entry> parameters) throws IOException, OAuthException, URISyntaxException {
        accessor.accessToken = null;
        accessor.tokenSecret = null;
        Object accessorSecret = accessor.getProperty("oauth_accessor_secret");
        if (accessorSecret != null) {
            ArrayList<? extends Map.Entry> p = parameters == null ? new ArrayList<Map.Entry>(1) : new ArrayList<Map.Entry>(parameters);
            p.add(new OAuth.Parameter("oauth_accessor_secret", accessorSecret.toString()));
            parameters = p;
        }
        OAuthMessage response = this.invoke(accessor, httpMethod, accessor.consumer.serviceProvider.requestTokenURL, parameters);
        accessor.requestToken = response.getParameter("oauth_token");
        accessor.tokenSecret = response.getParameter("oauth_token_secret");
        if (accessor.requestToken == null) {
            OAuthProblemException problem = new OAuthProblemException("parameter_absent");
            problem.setParameter("oauth_parameters_absent", "oauth_token");
            problem.getParameters().putAll(response.getDump());
            throw problem;
        }
    }

    public void getRequestToken(OAuthAccessor accessor) throws IOException, OAuthException, URISyntaxException {
        this.getRequestToken(accessor, null);
    }

    public OAuthMessage invoke(OAuthAccessor accessor, String httpMethod, String url, Collection<? extends Map.Entry> parameters) throws IOException, OAuthException, URISyntaxException {
        String ps = (String)accessor.consumer.getProperty(PARAMETER_STYLE);
        ParameterStyle style = ps == null ? ParameterStyle.BODY : Enum.valueOf(ParameterStyle.class, ps);
        return this.invoke(accessor.newRequestMessage(httpMethod, url, parameters), style);
    }

    public OAuthMessage invoke(OAuthAccessor accessor, String url, Collection<? extends Map.Entry> parameters) throws IOException, OAuthException, URISyntaxException {
        return this.invoke(accessor, null, url, parameters);
    }

    public OAuthMessage invoke(OAuthMessage request) throws IOException, OAuthException {
        return this.invoke(request, ParameterStyle.BODY);
    }

    public OAuthMessage invoke(OAuthMessage request, ParameterStyle style) throws IOException, OAuthException {
        boolean isPost = "POST".equalsIgnoreCase(request.method);
        boolean isPut = "PUT".equalsIgnoreCase(request.method);
        InputStream body = request.getBodyAsStream();
        if (!(style != ParameterStyle.BODY || isPost && body == null)) {
            style = ParameterStyle.QUERY_STRING;
        }
        String url = request.URL;
        ArrayList<OAuth.Parameter> headers = new ArrayList<OAuth.Parameter>();
        String contentType = request.getContentType();
        switch (style) {
            case QUERY_STRING: {
                url = OAuth.addParameters(url, request.getParameters());
                break;
            }
            case BODY: {
                body = new ByteArrayInputStream(OAuth.formEncode(request.getParameters()).getBytes(request.getContentCharset()));
                contentType = "application/x-www-form-urlencoded";
                break;
            }
            case AUTHORIZATION_HEADER: {
                headers.add(new OAuth.Parameter("Authorization", request.getAuthorizationHeader("")));
                List<Map.Entry<String, String>> others = request.getParameters();
                if (others == null || others.isEmpty()) break;
                others = new ArrayList<Map.Entry<String, String>>(others);
                Iterator<Map.Entry<String, String>> p = others.iterator();
                while (p.hasNext()) {
                    if (!p.next().getKey().startsWith("oauth_")) continue;
                    p.remove();
                }
                if (isPost && body == null) {
                    body = new ByteArrayInputStream(OAuth.formEncode(others).getBytes(request.getContentCharset()));
                    contentType = "application/x-www-form-urlencoded";
                    break;
                }
                url = OAuth.addParameters(url, others);
            }
        }
        if ((isPost || isPut) && contentType != null) {
            headers.add(new OAuth.Parameter("Content-Type", contentType));
        }
        return this.invoke(request.method, url, headers, body, request.getContentCharset());
    }

    protected abstract OAuthMessage invoke(String var1, String var2, Collection<? extends Map.Entry<String, String>> var3, InputStream var4, String var5) throws IOException, OAuthException;

    protected static class ExcerptInputStream
    extends FilterInputStream {
        public static final byte[] ELLIPSIS = " ...".getBytes();
        private static final int maxSize = 1024;
        private final ByteArrayOutputStream excerpt = new ByteArrayOutputStream();

        public ExcerptInputStream(InputStream in) {
            super(in);
        }

        public void copyAll(OutputStream into) throws IOException {
            int n;
            byte[] b = new byte[1024];
            while (0 < (n = this.read(b))) {
                into.write(b, 0, n);
            }
        }

        public byte[] getExcerpt() {
            return this.excerpt.toByteArray();
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            return this.read(b) <= 0 ? -1 : ExcerptInputStream.unsigned(b[0]);
        }

        private static int unsigned(byte b) {
            return b >= 0 ? b : b + 256;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int offset, int length) throws IOException {
            int e;
            int n = super.read(b, offset, length);
            if (n > 0 && (e = Math.min(n, 1024 - this.excerpt.size())) >= 0) {
                this.excerpt.write(b, offset, e);
                if (e < n) {
                    this.excerpt.write(ELLIPSIS);
                }
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ParameterStyle {
        AUTHORIZATION_HEADER,
        BODY,
        QUERY_STRING;

    }
}

