/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client;

import java.io.IOException;
import net.oauth.OAuth;
import net.oauth.OAuthMessage;

public abstract class OAuthResponseMessage
extends OAuthMessage {
    protected static final String HTTP_REQUEST_HEADERS = "HTTP request headers";
    protected static final String EOL = "\r\n";

    protected OAuthResponseMessage(String method, String URL2) throws IOException {
        super(method, URL2, NO_PARAMETERS);
    }

    protected void decodeWWWAuthenticate(String header) {
        for (OAuth.Parameter parameter : OAuthResponseMessage.decodeAuthorization(header)) {
            if ("realm".equalsIgnoreCase(parameter.getKey())) continue;
            this.addParameter(parameter);
        }
    }

    protected void completeParameters() throws IOException {
        this.addParameters(OAuth.decodeForm(this.getBodyAsString()));
    }

    protected boolean isDecodable(String contentType) {
        if (contentType != null) {
            int sep = contentType.indexOf(59);
            String mimeType = sep < 0 ? contentType : contentType.substring(0, sep);
            if ("text/html".equalsIgnoreCase(mimeType = mimeType.trim())) {
                return false;
            }
        }
        return true;
    }
}

