/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.client.OAuthClient;
import net.oauth.client.URLConnectionResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthURLConnectionClient
extends OAuthClient {
    private static final String EOL = "\r\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OAuthMessage invoke(String httpMethod, String urlString, Collection<? extends Map.Entry<String, String>> addHeaders, InputStream body, String bodyEncoding) throws IOException, OAuthException {
        HttpURLConnection http;
        int statusCode;
        URL url = new URL(urlString);
        URLConnection connection = url.openConnection();
        connection.setDoInput(true);
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection http2 = (HttpURLConnection)connection;
            http2.setRequestMethod(httpMethod);
            http2.setInstanceFollowRedirects(false);
        }
        StringBuilder headers = new StringBuilder(httpMethod);
        headers.append(" ").append(url.getPath());
        String query = url.getQuery();
        if (query != null && query.length() > 0) {
            headers.append("?").append(query);
        }
        headers.append(EOL);
        for (Map.Entry<String, List<String>> header : connection.getRequestProperties().entrySet()) {
            String key = header.getKey();
            for (String value : header.getValue()) {
                headers.append(key).append(": ").append(value).append(EOL);
            }
        }
        for (Map.Entry<String, String> entry : addHeaders) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
            headers.append(entry.getKey()).append(": ").append(entry.getValue());
        }
        OAuthClient.ExcerptInputStream input = new OAuthClient.ExcerptInputStream(body);
        if (body != null) {
            connection.setDoOutput(true);
            OutputStream outputStream = connection.getOutputStream();
            try {
                input.copyAll(outputStream);
            }
            finally {
                outputStream.close();
            }
        }
        URLConnectionResponse uRLConnectionResponse = new URLConnectionResponse(httpMethod, urlString, headers.toString(), input.getExcerpt(), bodyEncoding, connection);
        if (connection instanceof HttpURLConnection && (statusCode = (http = (HttpURLConnection)connection).getResponseCode()) != 200) {
            OAuthProblemException problem = new OAuthProblemException();
            problem.getParameters().putAll(uRLConnectionResponse.getDump());
            throw problem;
        }
        return uRLConnectionResponse;
    }
}

