/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.oauth.OAuth;
import net.oauth.client.OAuthResponseMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLConnectionResponse
extends OAuthResponseMessage {
    private final String requestHeaders;
    private final byte[] requestBody;
    private final String requestEncoding;
    private final URLConnection connection;
    private String bodyAsString = null;
    private final String contentType;

    public URLConnectionResponse(String method, String url, String requestHeaders, byte[] requestBody, String requestEncoding, URLConnection connection) throws IOException {
        super(method, url);
        this.requestHeaders = requestHeaders;
        this.requestBody = requestBody;
        this.requestEncoding = requestEncoding;
        this.connection = connection;
        List<String> wwwAuthHeaders = connection.getHeaderFields().get("WWW-Authenticate");
        if (wwwAuthHeaders != null) {
            for (String header : wwwAuthHeaders) {
                this.decodeWWWAuthenticate(header);
            }
        }
        this.contentType = connection.getContentType();
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public InputStream getBodyAsStream() throws IOException {
        if (this.bodyAsString == null) {
            try {
                return this.connection.getInputStream();
            }
            catch (IOException ohWell) {
                return null;
            }
        }
        return super.getBodyAsStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBodyAsString() throws IOException {
        InputStream input;
        if (this.bodyAsString == null && (input = this.getBodyAsStream()) != null) {
            try {
                int len;
                String encoding = this.connection.getContentEncoding();
                if (encoding == null) {
                    encoding = "ISO-8859-1";
                }
                InputStreamReader reader = new InputStreamReader(input, encoding);
                StringBuilder b = new StringBuilder();
                char[] c = new char[1024];
                while (0 < (len = reader.read(c))) {
                    b.append(c, 0, len);
                }
                this.bodyAsString = b.toString();
            }
            finally {
                input.close();
            }
        }
        return this.bodyAsString;
    }

    @Override
    protected void completeParameters() throws IOException {
        if (this.isDecodable(this.connection.getContentType())) {
            super.completeParameters();
        }
    }

    @Override
    protected void dump(Map<String, Object> into) throws IOException {
        String value;
        super.dump(into);
        into.put("HTTP request headers", this.requestHeaders);
        StringBuilder request = new StringBuilder(this.requestHeaders);
        request.append("\r\n");
        if (this.requestBody != null) {
            request.append(new String(this.requestBody, this.requestEncoding));
        }
        into.put("HTTP request", request.toString());
        HttpURLConnection http = this.connection instanceof HttpURLConnection ? (HttpURLConnection)this.connection : null;
        Integer statusCode = null;
        if (http != null) {
            statusCode = http.getResponseCode();
            into.put("HTTP status", statusCode);
        }
        StringBuilder response = new StringBuilder();
        ArrayList<OAuth.Parameter> responseHeaders = new ArrayList<OAuth.Parameter>();
        int i = 0;
        while ((value = this.connection.getHeaderField(i)) != null) {
            String name = this.connection.getHeaderFieldKey(i);
            if (i == 0 && name != null && http != null) {
                String firstLine = "HTTP " + statusCode;
                String message = http.getResponseMessage();
                if (message != null) {
                    firstLine = firstLine + " " + message;
                }
                response.append(firstLine).append("\r\n");
                responseHeaders.add(new OAuth.Parameter(null, firstLine));
            }
            if (name != null) {
                response.append(name).append(": ");
                name = name.toLowerCase();
            }
            response.append(value).append("\r\n");
            responseHeaders.add(new OAuth.Parameter(name, value));
            ++i;
        }
        into.put("response headers", responseHeaders);
        response.append("\r\n");
        String body = this.getBodyAsString();
        if (body != null) {
            response.append(body);
        }
        into.put("HTTP response", response.toString());
    }
}

