/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client.httpclient3;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import net.oauth.OAuth;
import net.oauth.client.OAuthResponseMessage;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpMethodResponse
extends OAuthResponseMessage {
    private final HttpMethod method;
    private final byte[] requestBody;
    private final String requestEncoding;
    private String bodyAsString = null;
    private final String contentType;

    public HttpMethodResponse(HttpMethod method, byte[] requestBody, String requestEncoding) throws IOException {
        super(method.getName(), method.getURI().toString());
        this.method = method;
        this.requestBody = requestBody;
        this.requestEncoding = requestEncoding;
        for (Header header : method.getResponseHeaders("WWW-Authenticate")) {
            this.decodeWWWAuthenticate(header.getValue());
        }
        Header[] headers = method.getResponseHeaders("Content-Type");
        this.contentType = headers == null || headers.length <= 0 ? null : headers[headers.length - 1].getValue();
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public InputStream getBodyAsStream() throws IOException {
        if (this.bodyAsString == null) {
            return this.method.getResponseBodyAsStream();
        }
        return super.getBodyAsStream();
    }

    @Override
    public String getBodyAsString() throws IOException {
        if (this.bodyAsString == null) {
            this.bodyAsString = this.method.getResponseBodyAsString();
        }
        return this.bodyAsString;
    }

    @Override
    protected void completeParameters() throws IOException {
        Header contentType = this.method.getResponseHeader("Content-Type");
        if (contentType == null || this.isDecodable(contentType.getValue())) {
            super.completeParameters();
        }
    }

    @Override
    protected void dump(Map<String, Object> into) throws IOException {
        super.dump(into);
        StringBuilder request = new StringBuilder(this.method.getName());
        request.append(" ").append(this.method.getPath());
        String query = this.method.getQueryString();
        if (query != null && query.length() > 0) {
            request.append("?").append(query);
        }
        request.append("\r\n");
        for (Header header : this.method.getRequestHeaders()) {
            request.append(header.getName()).append(": ").append(header.getValue()).append("\r\n");
        }
        into.put("HTTP request headers", request.toString());
        request.append("\r\n");
        if (this.requestBody != null) {
            request.append(new String(this.requestBody, this.requestEncoding));
        }
        into.put("HTTP request", request.toString());
        into.put("HTTP status", new Integer(this.method.getStatusCode()));
        ArrayList<OAuth.Parameter> responseHeaders = new ArrayList<OAuth.Parameter>();
        StringBuilder response = new StringBuilder();
        String value = this.method.getStatusLine().toString();
        response.append(value).append("\r\n");
        responseHeaders.add(new OAuth.Parameter(null, value));
        for (Header header : this.method.getResponseHeaders()) {
            String name = header.getName();
            value = header.getValue();
            response.append(name).append(": ").append(value).append("\r\n");
            responseHeaders.add(new OAuth.Parameter(name.toLowerCase(), value));
        }
        into.put("response headers", responseHeaders);
        response.append("\r\n");
        String body = this.getBodyAsString();
        if (body != null) {
            response.append(body);
        }
        into.put("HTTP response", response.toString());
    }
}

