/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client.httpclient3;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.client.OAuthClient;
import net.oauth.client.httpclient3.HttpClientPool;
import net.oauth.client.httpclient3.HttpMethodResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthHttpClient
extends OAuthClient {
    private static final HttpClientPool NOT_POOLED = new HttpClientPool(){

        public HttpClient getHttpClient(URL server) {
            return new HttpClient();
        }
    };
    private final HttpClientPool clientPool;

    public OAuthHttpClient(HttpClientPool clientPool) {
        this.clientPool = clientPool;
    }

    public OAuthHttpClient() {
        this(NOT_POOLED);
    }

    @Override
    protected OAuthMessage invoke(String method, String url, Collection<? extends Map.Entry<String, String>> headers, InputStream body, String bodyEncoding) throws IOException, OAuthException {
        Object httpMethod;
        boolean isDelete = "DELETE".equalsIgnoreCase(method);
        boolean isPost = "POST".equalsIgnoreCase(method);
        boolean isPut = "PUT".equalsIgnoreCase(method);
        OAuthClient.ExcerptInputStream input = new OAuthClient.ExcerptInputStream(body);
        if (isPost || isPut) {
            Object entityEnclosingMethod = isPost ? new PostMethod(url) : new PutMethod(url);
            if (body != null) {
                entityEnclosingMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)input));
            }
            httpMethod = entityEnclosingMethod;
        } else {
            httpMethod = isDelete ? new DeleteMethod(url) : new GetMethod(url);
        }
        httpMethod.setFollowRedirects(false);
        for (Map.Entry<String, String> entry : headers) {
            httpMethod.addRequestHeader(entry.getKey(), entry.getValue());
        }
        HttpClient client = this.clientPool.getHttpClient(new URL(httpMethod.getURI().toString()));
        client.executeMethod((HttpMethod)httpMethod);
        HttpMethodResponse httpMethodResponse = new HttpMethodResponse((HttpMethod)httpMethod, input.getExcerpt(), bodyEncoding);
        int statusCode = httpMethod.getStatusCode();
        if (statusCode != 200) {
            OAuthProblemException problem = new OAuthProblemException();
            problem.getParameters().putAll(httpMethodResponse.getDump());
            throw problem;
        }
        return httpMethodResponse;
    }
}

