/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client.httpclient4;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import net.oauth.OAuth;
import net.oauth.client.OAuthResponseMessage;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpMethodResponse
extends OAuthResponseMessage {
    private final HttpRequestBase httpRequest;
    private final HttpResponse httpResponse;
    private final byte[] requestBody;
    private final String requestEncoding;
    private String bodyAsString = null;
    private final String contentType;

    public HttpMethodResponse(HttpRequestBase request, HttpResponse response, byte[] requestBody, String requestEncoding) throws IOException {
        super(request.getMethod(), request.getURI().toString());
        this.httpRequest = request;
        this.httpResponse = response;
        this.requestBody = requestBody;
        this.requestEncoding = requestEncoding;
        for (Header header : response.getHeaders("WWW-Authenticate")) {
            this.decodeWWWAuthenticate(header.getValue());
        }
        Header[] headers = response.getHeaders("Content-Type");
        this.contentType = headers == null || headers.length <= 0 ? null : headers[headers.length - 1].getValue();
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public InputStream getBodyAsStream() throws IOException {
        if (this.bodyAsString == null) {
            return this.httpResponse.getEntity().getContent();
        }
        return super.getBodyAsStream();
    }

    @Override
    public String getBodyAsString() throws IOException {
        if (this.bodyAsString == null) {
            HttpEntity entity = this.httpResponse.getEntity();
            this.bodyAsString = entity == null ? null : EntityUtils.toString((HttpEntity)entity);
        }
        return this.bodyAsString;
    }

    @Override
    protected void completeParameters() throws IOException {
        Header contentType = this.httpResponse.getFirstHeader("Content-Type");
        if (contentType == null || this.isDecodable(contentType.getValue())) {
            super.completeParameters();
        }
    }

    @Override
    protected void dump(Map<String, Object> into) throws IOException {
        super.dump(into);
        StringBuilder request = new StringBuilder(this.httpRequest.getMethod());
        request.append(" ").append(this.httpRequest.getURI().getPath());
        String query = this.httpRequest.getURI().getQuery();
        if (query != null && query.length() > 0) {
            request.append("?").append(query);
        }
        request.append("\r\n");
        for (Header header : this.httpRequest.getAllHeaders()) {
            request.append(header.getName()).append(": ").append(header.getValue()).append("\r\n");
        }
        into.put("HTTP request headers", request.toString());
        request.append("\r\n");
        if (this.requestBody != null) {
            request.append(new String(this.requestBody, this.requestEncoding));
        }
        into.put("HTTP request", request.toString());
        into.put("HTTP status", new Integer(this.httpResponse.getStatusLine().getStatusCode()));
        ArrayList<OAuth.Parameter> responseHeaders = new ArrayList<OAuth.Parameter>();
        StringBuilder response = new StringBuilder();
        String value = this.httpResponse.getStatusLine().toString();
        response.append(value).append("\r\n");
        responseHeaders.add(new OAuth.Parameter(null, value));
        for (Header header : this.httpResponse.getAllHeaders()) {
            String name = header.getName();
            value = header.getValue();
            response.append(name).append(": ").append(value).append("\r\n");
            responseHeaders.add(new OAuth.Parameter(name.toLowerCase(), value));
        }
        into.put("response headers", responseHeaders);
        response.append("\r\n");
        String body = this.getBodyAsString();
        if (body != null) {
            response.append(body);
        }
        into.put("HTTP response", response.toString());
    }
}

