/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client.httpclient4;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.client.OAuthClient;
import net.oauth.client.httpclient4.HttpClientPool;
import net.oauth.client.httpclient4.HttpMethodResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthHttpClient
extends OAuthClient {
    private final HttpClientPool clientPool;
    private static final HttpClientPool NOT_POOLED = new HttpClientPool(){

        public HttpClient getHttpClient(URL server) {
            return new DefaultHttpClient();
        }
    };

    public OAuthHttpClient(HttpClientPool clientPool) {
        this.clientPool = clientPool;
    }

    public OAuthHttpClient() {
        this(NOT_POOLED);
    }

    @Override
    protected OAuthMessage invoke(String method, String url, Collection<? extends Map.Entry<String, String>> headers, InputStream body, String bodyEncoding) throws IOException, OAuthException {
        Object httpRequest;
        boolean isDelete = "DELETE".equalsIgnoreCase(method);
        boolean isPost = "POST".equalsIgnoreCase(method);
        boolean isPut = "PUT".equalsIgnoreCase(method);
        OAuthClient.ExcerptInputStream input = new OAuthClient.ExcerptInputStream(body);
        if (isPost || isPut) {
            Object entityEnclosingMethod = new HttpPost(url);
            entityEnclosingMethod = isPost ? new HttpPost(url) : new HttpPut(url);
            if (body != null) {
                entityEnclosingMethod.setEntity((HttpEntity)new InputStreamEntity((InputStream)input, -1L));
            }
            httpRequest = entityEnclosingMethod;
        } else {
            httpRequest = isDelete ? new HttpDelete(url) : new HttpGet(url);
        }
        for (Map.Entry<String, String> entry : headers) {
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }
        HttpClient client = this.clientPool.getHttpClient(new URL(httpRequest.getURI().toString()));
        client.getParams().setBooleanParameter("http.protocol.handle-redirects", false);
        HttpResponse httpResponse = client.execute((HttpUriRequest)httpRequest);
        HttpMethodResponse response = new HttpMethodResponse((HttpRequestBase)httpRequest, httpResponse, input.getExcerpt(), bodyEncoding);
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            OAuthProblemException problem = new OAuthProblemException();
            problem.getParameters().putAll(response.getDump());
            throw problem;
        }
        return response;
    }
}

