/*
 * Decompiled with CFR 0.152.
 */
package com.gtcgroup.justify.cdi.helper.internal;

import com.gtcgroup.justify.core.exception.internal.JustifyRuntimeException;
import com.gtcgroup.justify.core.helper.JstPortableJndiUtilHelper;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.deltaspike.cdise.api.CdiContainer;
import org.apache.deltaspike.cdise.api.CdiContainerLoader;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.apache.deltaspike.core.api.provider.BeanProvider;

public enum BeanManagerUtilHelper {
    INSTANCE;

    private static CdiContainer cdiContainer;
    public static final String JNDI_BEANMANAGER = "java:comp/BeanManager";

    private static JustifyRuntimeException createException(Class<?> clazz, Exception e, String additionalMessage) {
        StringBuilder message = new StringBuilder();
        message.append("The class [");
        message.append(clazz.getName());
        message.append("] could not be found.");
        message.append(additionalMessage);
        return new JustifyRuntimeException(message.toString() + "\n\t[" + e.getMessage() + "].\n");
    }

    public static BeanManager getBeanManager() {
        return BeanManagerProvider.getInstance().getBeanManager();
    }

    public static CdiContainer getCdiContainer() {
        return cdiContainer;
    }

    private static void initializeCdiBeanManager() {
        cdiContainer = CdiContainerLoader.getCdiContainer();
        cdiContainer.boot();
        cdiContainer.getContextControl().startContexts();
    }

    @SafeVarargs
    public static boolean initializeCdiScope(Class<? extends Annotation> ... scopeClasses) {
        for (Class<? extends Annotation> clazz : scopeClasses) {
            cdiContainer.getContextControl().stopContext(clazz);
            cdiContainer.getContextControl().startContext(clazz);
        }
        return true;
    }

    public static boolean initializeCdiScopes() {
        cdiContainer.getContextControl().stopContexts();
        cdiContainer.getContextControl().startContexts();
        return true;
    }

    private static void initializeJndiContainer() {
        BeanManager beanManager = BeanManagerUtilHelper.getBeanManager();
        JstPortableJndiUtilHelper.bind((String)JNDI_BEANMANAGER, (Object)beanManager);
    }

    public static boolean injectFields(Object instance) {
        BeanProvider.injectFields((Object)instance);
        return true;
    }

    public static <BEAN> BEAN retrieveManagedBean(Class<BEAN> clazz) {
        return BeanManagerUtilHelper.retrieveManagedBean(clazz, false);
    }

    public static <BEAN> BEAN retrieveManagedBean(Class<BEAN> clazz, boolean suppressException) {
        Object bean = null;
        try {
            bean = BeanProvider.getContextualReference(clazz, (boolean)false, (Annotation[])new Annotation[0]);
        }
        catch (Exception e) {
            if (suppressException) {
                bean = null;
            }
            throw BeanManagerUtilHelper.createException(clazz, e, "\n\n\t*** Ensure a beans.xml file is properly configured. ***\n");
        }
        return (BEAN)bean;
    }

    static {
        BeanManagerUtilHelper.initializeCdiBeanManager();
        BeanManagerUtilHelper.initializeJndiContainer();
    }
}

