/*
 * Decompiled with CFR 0.152.
 */
package com.gu.toolargetool;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.gu.toolargetool.Formatter;
import com.gu.toolargetool.FragmentSavedStateLogger;
import com.gu.toolargetool.Logger;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u001a\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0011H\u0016J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u0006\u0010\u001e\u001a\u00020\u0013J\u0006\u0010\u001f\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/gu/toolargetool/ActivitySavedStateLogger;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "formatter", "Lcom/gu/toolargetool/Formatter;", "logger", "Lcom/gu/toolargetool/Logger;", "logFragments", "", "(Lcom/gu/toolargetool/Formatter;Lcom/gu/toolargetool/Logger;Z)V", "fragmentLogger", "Lcom/gu/toolargetool/FragmentSavedStateLogger;", "<set-?>", "isLogging", "()Z", "savedStates", "Ljava/util/HashMap;", "Landroid/app/Activity;", "Landroid/os/Bundle;", "logAndRemoveSavedState", "", "activity", "onActivityCreated", "savedInstanceState", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "outState", "onActivityStarted", "onActivityStopped", "startLogging", "stopLogging", "toolargetool_release"})
public final class ActivitySavedStateLogger
implements Application.ActivityLifecycleCallbacks {
    private final FragmentSavedStateLogger fragmentLogger;
    private final HashMap<Activity, Bundle> savedStates;
    private boolean isLogging;
    private final Formatter formatter;
    private final Logger logger;

    public final boolean isLogging() {
        return this.isLogging;
    }

    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (activity instanceof FragmentActivity && this.fragmentLogger != null) {
            ((FragmentActivity)activity).getSupportFragmentManager().registerFragmentLifecycleCallbacks((FragmentManager.FragmentLifecycleCallbacks)this.fragmentLogger, true);
        }
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.logAndRemoveSavedState(activity);
    }

    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        if (this.isLogging) {
            ((Map)this.savedStates).put(activity, outState);
        }
    }

    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.logAndRemoveSavedState(activity);
    }

    private final void logAndRemoveSavedState(Activity activity) {
        Bundle savedState = this.savedStates.remove(activity);
        if (savedState != null) {
            try {
                String message = this.formatter.format(activity, savedState);
                this.logger.log(message);
            }
            catch (RuntimeException e) {
                this.logger.logException(e);
            }
        }
    }

    public final void startLogging() {
        block0: {
            this.isLogging = true;
            FragmentSavedStateLogger fragmentSavedStateLogger = this.fragmentLogger;
            if (fragmentSavedStateLogger == null) break block0;
            fragmentSavedStateLogger.startLogging$toolargetool_release();
        }
    }

    public final void stopLogging() {
        block0: {
            this.isLogging = false;
            this.savedStates.clear();
            FragmentSavedStateLogger fragmentSavedStateLogger = this.fragmentLogger;
            if (fragmentSavedStateLogger == null) break block0;
            fragmentSavedStateLogger.stopLogging$toolargetool_release();
        }
    }

    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityResumed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public ActivitySavedStateLogger(@NotNull Formatter formatter, @NotNull Logger logger, boolean logFragments) {
        Intrinsics.checkNotNullParameter((Object)formatter, (String)"formatter");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.formatter = formatter;
        this.logger = logger;
        this.fragmentLogger = logFragments ? new FragmentSavedStateLogger(this.formatter, this.logger) : null;
        this.savedStates = new HashMap();
    }
}

