/*
 * Decompiled with CFR 0.152.
 */
package com.gu.elasticsearch.plugin.cloudwatch;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.EnvironmentVariableCredentialsProvider;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.auth.SystemPropertiesCredentialsProvider;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.StandardUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.NodeIndicesStats;
import org.elasticsearch.monitor.jvm.JvmStats;
import org.elasticsearch.monitor.os.OsStats;
import org.elasticsearch.node.service.NodeService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloudwatchPluginService
extends AbstractLifecycleComponent<CloudwatchPluginService> {
    private Client client;
    private volatile Thread cloudwatchThread;
    private volatile boolean stopped;
    private final TimeValue frequency;
    private final IndicesService indicesService;
    private NodeService nodeService;
    private AmazonCloudWatch cloudwatch;
    private final String clusterName;
    private boolean indexStatsEnabled;
    private String namespace;

    @Inject
    public CloudwatchPluginService(Settings settings, Client client, IndicesService indicesService, NodeService nodeService) {
        super(settings);
        this.client = client;
        this.nodeService = nodeService;
        this.indicesService = indicesService;
        this.namespace = this.getNamespace();
        this.cloudwatch = this.getCloudwatchClient();
        this.indexStatsEnabled = settings.getAsBoolean("metrics.cloudwatch.index_stats_enabled", Boolean.valueOf(false));
        this.frequency = settings.getAsTime("metrics.cloudwatch.frequency", TimeValue.timeValueMinutes((long)1L));
        this.clusterName = settings.get("cluster.name");
    }

    protected String getNamespace() {
        String namespace = this.settings.get("metrics.cloudwatch.namespace");
        if (namespace == null) {
            namespace = "Elasticsearch";
        }
        return namespace;
    }

    protected AWSCredentialsProvider getCredentialsProvider() {
        String accessKey = this.settings.get("metrics.cloudwatch.aws.access_key");
        String secretKey = this.settings.get("metrics.cloudwatch.aws.secret_key");
        AWSCredentialsProviderChain awsCredentialsProvider = accessKey == null && secretKey == null ? new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new EnvironmentVariableCredentialsProvider(), new SystemPropertiesCredentialsProvider(), new InstanceProfileCredentialsProvider()}) : new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new StaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey))});
        return awsCredentialsProvider;
    }

    protected void doClose() throws ElasticsearchException {
    }

    protected void doStart() throws ElasticsearchException {
        this.cloudwatchThread = EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"cloudwatch_poster").newThread(new CloudwatchPoster());
        this.cloudwatchThread.start();
        this.logger.info("Cloudwatch reporting triggered every [{}]", new Object[]{this.frequency});
    }

    protected void doStop() throws ElasticsearchException {
        if (this.stopped) {
            return;
        }
        if (this.cloudwatchThread != null) {
            this.cloudwatchThread.interrupt();
        }
        this.stopped = true;
        this.logger.info("Cloudwatch poster stopped", new Object[0]);
    }

    private String getCloudwatchEndpoint() {
        String region = this.settings.get("metrics.cloudwatch.aws.region");
        if ("us-east-1".equals(region) || "us-west-2".equals(region) || "us-west-1".equals(region) || "eu-west-1".equals(region) || "ap-southeast-1".equals(region) || "ap-southeast-2".equals(region) || "ap-northeast-1".equals(region) || "sa-east-1".equals(region)) {
            return "monitoring." + region + ".amazonaws.com";
        }
        this.logger.warn("Unrecognized region [{}], using the default, eu-west-1", new Object[]{region});
        return "monitoring.eu-west-1.amazonaws.com";
    }

    private AmazonCloudWatch getCloudwatchClient() {
        AWSCredentialsProvider awsCredentialsProvider = this.getCredentialsProvider();
        String cloudwatchEndpoint = this.getCloudwatchEndpoint();
        AmazonCloudWatchClient cloudwatch = new AmazonCloudWatchClient(awsCredentialsProvider);
        cloudwatch.setEndpoint(cloudwatchEndpoint);
        return cloudwatch;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CloudwatchPoster
    implements Runnable {
        @Override
        public void run() {
            while (!CloudwatchPluginService.this.stopped) {
                CloudwatchPluginService.this.logger.info("Running Cloudwatch plugin tasks", new Object[0]);
                this.sendStats();
                try {
                    Thread.sleep(CloudwatchPluginService.this.frequency.millis());
                }
                catch (InterruptedException e1) {}
            }
        }

        private void sendStats() {
            Date now = new Date();
            this.sendClusterHealthStats(now);
            NodeIndicesStats nodeIndicesStats = CloudwatchPluginService.this.indicesService.stats(false);
            NodeStats nodeStats = CloudwatchPluginService.this.nodeService.stats(new CommonStatsFlags(new CommonStatsFlags.Flag[0]).clear(), true, false, true, false, false, false, false, false, false);
            String nodeAddress = (String)CloudwatchPluginService.this.nodeService.attributes().get((Object)"http_address");
            if (nodeAddress != null) {
                this.sendOsStats(now, nodeStats, nodeAddress);
                this.sendJVMStats(now, nodeStats, nodeAddress);
                this.sendDocsStats(now, nodeAddress, nodeIndicesStats);
                if (CloudwatchPluginService.this.indexStatsEnabled) {
                    this.sendIndexStats(now, nodeAddress);
                }
            } else {
                CloudwatchPluginService.this.logger.warn("Node attribute http_address still not set, skipping node metrics.", new Object[0]);
            }
        }

        private void putCloudwatchMetricData(PutMetricDataRequest request) {
            try {
                CloudwatchPluginService.this.cloudwatch.putMetricData(request);
            }
            catch (AmazonClientException e) {
                CloudwatchPluginService.this.logger.error("Error trying to put metric data!", (Throwable)e, new Object[0]);
            }
        }

        private void sendClusterHealthStats(final Date now) {
            CloudwatchPluginService.this.client.admin().cluster().health(new ClusterHealthRequest(new String[0]), (ActionListener)new ActionListener<ClusterHealthResponse>(){

                public void onResponse(ClusterHealthResponse healthResponse) {
                    PutMetricDataRequest request = new PutMetricDataRequest();
                    request.setNamespace(CloudwatchPluginService.this.namespace);
                    ArrayList data = Lists.newArrayList();
                    ClusterHealthStatus clusterStatus = healthResponse.getStatus();
                    Byte clusterStatusValue = clusterStatus.value();
                    data.add(CloudwatchPoster.this.clusterDatum(now, "NumberOfNodes", healthResponse.getNumberOfNodes()));
                    data.add(CloudwatchPoster.this.clusterDatum(now, "NumberOfDataNodes", healthResponse.getNumberOfDataNodes()));
                    data.add(CloudwatchPoster.this.clusterDatum(now, "ActivePrimaryShards", healthResponse.getActivePrimaryShards()));
                    data.add(CloudwatchPoster.this.clusterDatum(now, "ActiveShards", healthResponse.getActiveShards()));
                    data.add(CloudwatchPoster.this.clusterDatum(now, "RelocatingShards", healthResponse.getRelocatingShards()));
                    data.add(CloudwatchPoster.this.clusterDatum(now, "InitializingShards", healthResponse.getInitializingShards()));
                    data.add(CloudwatchPoster.this.clusterDatum(now, "UnassignedShards", healthResponse.getUnassignedShards()));
                    data.add(CloudwatchPoster.this.clusterDatum(now, "ClusterHealthStatus", clusterStatusValue.doubleValue()));
                    request.setMetricData((Collection)data);
                    CloudwatchPoster.this.putCloudwatchMetricData(request);
                }

                public void onFailure(Throwable e) {
                    CloudwatchPluginService.this.logger.error("Asking for cluster health failed.", e, new Object[0]);
                }
            });
        }

        private void sendDocsStats(Date now, String nodeAddress, NodeIndicesStats nodeIndicesStats) {
            PutMetricDataRequest request = new PutMetricDataRequest();
            request.setNamespace(CloudwatchPluginService.this.namespace);
            ArrayList docsData = Lists.newArrayList();
            DocsStats docsStats = nodeIndicesStats.getDocs();
            long count = docsStats != null ? docsStats.getCount() : 0L;
            long deleted = docsStats != null ? docsStats.getDeleted() : 0L;
            docsData.add(this.nodeDatum(now, nodeAddress, "DocsCount", count, StandardUnit.Count));
            docsData.add(this.nodeDatum(now, nodeAddress, "DocsDeleted", deleted, StandardUnit.Count));
            request.setMetricData((Collection)docsData);
            this.putCloudwatchMetricData(request);
        }

        private void sendJVMStats(Date now, NodeStats nodeStats, String nodeAddress) {
            PutMetricDataRequest request = new PutMetricDataRequest();
            request.setNamespace(CloudwatchPluginService.this.namespace);
            JvmStats jvmStats = nodeStats.getJvm();
            ArrayList jvmData = Lists.newArrayList();
            jvmData.add(this.nodeDatum(now, nodeAddress, "JVMUptime", jvmStats.uptime().seconds(), StandardUnit.Seconds));
            jvmData.add(this.nodeDatum(now, nodeAddress, "JVMMemHeapCommitted", jvmStats.mem().heapCommitted().bytes(), StandardUnit.Bytes));
            jvmData.add(this.nodeDatum(now, nodeAddress, "JVMMemHeapUsed", jvmStats.mem().heapUsed().bytes(), StandardUnit.Bytes));
            jvmData.add(this.nodeDatum(now, nodeAddress, "JVMMemNonHeapCommitted", jvmStats.mem().nonHeapCommitted().bytes(), StandardUnit.Bytes));
            jvmData.add(this.nodeDatum(now, nodeAddress, "JVMMemNonHeapUsed", jvmStats.mem().nonHeapUsed().bytes(), StandardUnit.Bytes));
            jvmData.add(this.nodeDatum(now, nodeAddress, "JVMThreads", jvmStats.threads().count(), StandardUnit.Count));
            jvmData.add(this.nodeDatum(now, nodeAddress, "JVMThreadPeak", jvmStats.threads().peakCount(), StandardUnit.Count));
            Iterator gcs = jvmStats.gc().iterator();
            long collectionCount = 0L;
            long collectionTime = 0L;
            while (gcs.hasNext()) {
                JvmStats.GarbageCollector gc = (JvmStats.GarbageCollector)gcs.next();
                collectionCount += gc.collectionCount();
                collectionTime += gc.collectionTime().seconds();
            }
            jvmData.add(this.nodeDatum(now, nodeAddress, "JVMGCCollectionCount", collectionCount, StandardUnit.Count));
            jvmData.add(this.nodeDatum(now, nodeAddress, "JVMGCCollectionTime", collectionTime, StandardUnit.Seconds));
            request.setMetricData((Collection)jvmData);
            this.putCloudwatchMetricData(request);
        }

        private void sendOsStats(Date now, NodeStats nodeStats, String nodeAddress) {
            PutMetricDataRequest request = new PutMetricDataRequest();
            request.setNamespace(CloudwatchPluginService.this.namespace);
            OsStats osStats = nodeStats.getOs();
            ArrayList osData = Lists.newArrayList();
            osData.add(this.nodeDatum(now, nodeAddress, "OsCpuSys", osStats.cpu().sys(), StandardUnit.Percent));
            osData.add(this.nodeDatum(now, nodeAddress, "OsCpuIdle", osStats.cpu().idle(), StandardUnit.Percent));
            osData.add(this.nodeDatum(now, nodeAddress, "OsCpuUser", osStats.cpu().user(), StandardUnit.Percent));
            osData.add(this.nodeDatum(now, nodeAddress, "OsMemFreeBytes", osStats.mem().free().bytes(), StandardUnit.Bytes));
            osData.add(this.nodeDatum(now, nodeAddress, "OsMemUsedBytes", osStats.mem().used().bytes(), StandardUnit.Bytes));
            osData.add(this.nodeDatum(now, nodeAddress, "OsMemFreePercent", osStats.mem().freePercent(), StandardUnit.Percent));
            osData.add(this.nodeDatum(now, nodeAddress, "OsMemUsedPercent", osStats.mem().usedPercent(), StandardUnit.Percent));
            osData.add(this.nodeDatum(now, nodeAddress, "OsMemActualFreeBytes", osStats.mem().actualFree().bytes(), StandardUnit.Bytes));
            osData.add(this.nodeDatum(now, nodeAddress, "OsMemActualUsedBytes", osStats.mem().actualUsed().bytes(), StandardUnit.Bytes));
            osData.add(this.nodeDatum(now, nodeAddress, "OsSwapFreeBytes", osStats.swap().free().bytes(), StandardUnit.Bytes));
            osData.add(this.nodeDatum(now, nodeAddress, "OsSwapUsedBytes", osStats.swap().used().bytes(), StandardUnit.Bytes));
            request.setMetricData((Collection)osData);
            this.putCloudwatchMetricData(request);
        }

        private void sendIndexStats(Date now, String nodeAddress) {
            try {
                PutMetricDataRequest request = new PutMetricDataRequest();
                request.setNamespace(CloudwatchPluginService.this.namespace);
                for (IndexShard indexShard : CloudwatchPluginService.this.indicesService) {
                    ArrayList data = Lists.newArrayList();
                    ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
                    dimensions.add(new Dimension().withName("IndexName").withValue(indexShard.shardId().index().name()));
                    dimensions.add(new Dimension().withName("ShardId").withValue(indexShard.shardId().id() + ""));
                    DocsStats docsStats = indexShard.docStats();
                    long count = docsStats != null ? docsStats.getCount() : 0L;
                    data.add(this.nodeDatum(now, nodeAddress, "DocsCount", count, StandardUnit.Count, dimensions));
                    long deleted = docsStats != null ? docsStats.getDeleted() : 0L;
                    data.add(this.nodeDatum(now, nodeAddress, "DocsDeleted", deleted, StandardUnit.Count, dimensions));
                    StoreStats storeStats = indexShard.storeStats();
                    data.add(this.nodeDatum(now, nodeAddress, "StoreSize", storeStats.sizeInBytes(), StandardUnit.Bytes, dimensions));
                    data.add(this.nodeDatum(now, nodeAddress, "StoreThrottleTimeInNanos", storeStats.throttleTime().getNanos(), StandardUnit.None, dimensions));
                    request.setMetricData((Collection)data);
                    CloudwatchPluginService.this.cloudwatch.putMetricData(request);
                }
            }
            catch (AmazonClientException e) {
                CloudwatchPluginService.this.logger.error("Exception thrown by amazon while sending IndexStats", (Throwable)e, new Object[0]);
            }
        }

        private MetricDatum nodeDatum(Date timestamp, String nodeAddress, String metricName, double metricValue, StandardUnit unit, List<Dimension> dimensions) {
            MetricDatum datum = new MetricDatum();
            Dimension clusterNameDimension = new Dimension();
            clusterNameDimension.setName("ClusterName");
            clusterNameDimension.setValue(CloudwatchPluginService.this.clusterName);
            Dimension nodeNameDimension = new Dimension();
            nodeNameDimension.setName("NodeName");
            nodeNameDimension.setValue(nodeAddress);
            datum.setDimensions((Collection)Lists.newArrayList((Object[])new Dimension[]{clusterNameDimension, nodeNameDimension}));
            datum.getDimensions().addAll(dimensions);
            datum.setMetricName(metricName);
            datum.setTimestamp(timestamp);
            datum.setValue(Double.valueOf(metricValue));
            datum.setUnit(unit);
            return datum;
        }

        private MetricDatum nodeDatum(Date timestamp, String nodeAddress, String metricName, double metricValue, StandardUnit unit) {
            return this.nodeDatum(timestamp, nodeAddress, metricName, metricValue, unit, new ArrayList<Dimension>());
        }

        private MetricDatum clusterDatum(Date now, String metricName, double metricValue) {
            MetricDatum datum = new MetricDatum();
            Dimension dimension = new Dimension();
            dimension.setName("ClusterName");
            dimension.setValue(CloudwatchPluginService.this.clusterName);
            datum.setDimensions((Collection)Lists.newArrayList((Object[])new Dimension[]{dimension}));
            datum.setMetricName(metricName);
            datum.setTimestamp(now);
            datum.setValue(Double.valueOf(metricValue));
            datum.setUnit(StandardUnit.Count);
            return datum;
        }
    }
}

