/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.codedeploy.model.AutoScalingGroup;
import com.amazonaws.services.codedeploy.model.EC2TagFilter;
import com.amazonaws.services.codedeploy.model.RevisionLocation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DeploymentGroupInfo
implements Serializable,
Cloneable {
    private String applicationName;
    private String deploymentGroupId;
    private String deploymentGroupName;
    private String deploymentConfigName;
    private ListWithAutoConstructFlag<EC2TagFilter> ec2TagFilters;
    private ListWithAutoConstructFlag<AutoScalingGroup> autoScalingGroups;
    private String serviceRoleArn;
    private RevisionLocation targetRevision;

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public DeploymentGroupInfo withApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public String getDeploymentGroupId() {
        return this.deploymentGroupId;
    }

    public void setDeploymentGroupId(String deploymentGroupId) {
        this.deploymentGroupId = deploymentGroupId;
    }

    public DeploymentGroupInfo withDeploymentGroupId(String deploymentGroupId) {
        this.deploymentGroupId = deploymentGroupId;
        return this;
    }

    public String getDeploymentGroupName() {
        return this.deploymentGroupName;
    }

    public void setDeploymentGroupName(String deploymentGroupName) {
        this.deploymentGroupName = deploymentGroupName;
    }

    public DeploymentGroupInfo withDeploymentGroupName(String deploymentGroupName) {
        this.deploymentGroupName = deploymentGroupName;
        return this;
    }

    public String getDeploymentConfigName() {
        return this.deploymentConfigName;
    }

    public void setDeploymentConfigName(String deploymentConfigName) {
        this.deploymentConfigName = deploymentConfigName;
    }

    public DeploymentGroupInfo withDeploymentConfigName(String deploymentConfigName) {
        this.deploymentConfigName = deploymentConfigName;
        return this;
    }

    public List<EC2TagFilter> getEc2TagFilters() {
        if (this.ec2TagFilters == null) {
            this.ec2TagFilters = new ListWithAutoConstructFlag();
            this.ec2TagFilters.setAutoConstruct(true);
        }
        return this.ec2TagFilters;
    }

    public void setEc2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
        if (ec2TagFilters == null) {
            this.ec2TagFilters = null;
            return;
        }
        ListWithAutoConstructFlag ec2TagFiltersCopy = new ListWithAutoConstructFlag(ec2TagFilters.size());
        ec2TagFiltersCopy.addAll(ec2TagFilters);
        this.ec2TagFilters = ec2TagFiltersCopy;
    }

    public DeploymentGroupInfo withEc2TagFilters(EC2TagFilter ... ec2TagFilters) {
        if (this.getEc2TagFilters() == null) {
            this.setEc2TagFilters(new ArrayList<EC2TagFilter>(ec2TagFilters.length));
        }
        for (EC2TagFilter value : ec2TagFilters) {
            this.getEc2TagFilters().add(value);
        }
        return this;
    }

    public DeploymentGroupInfo withEc2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
        if (ec2TagFilters == null) {
            this.ec2TagFilters = null;
        } else {
            ListWithAutoConstructFlag ec2TagFiltersCopy = new ListWithAutoConstructFlag(ec2TagFilters.size());
            ec2TagFiltersCopy.addAll(ec2TagFilters);
            this.ec2TagFilters = ec2TagFiltersCopy;
        }
        return this;
    }

    public List<AutoScalingGroup> getAutoScalingGroups() {
        if (this.autoScalingGroups == null) {
            this.autoScalingGroups = new ListWithAutoConstructFlag();
            this.autoScalingGroups.setAutoConstruct(true);
        }
        return this.autoScalingGroups;
    }

    public void setAutoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
        if (autoScalingGroups == null) {
            this.autoScalingGroups = null;
            return;
        }
        ListWithAutoConstructFlag autoScalingGroupsCopy = new ListWithAutoConstructFlag(autoScalingGroups.size());
        autoScalingGroupsCopy.addAll(autoScalingGroups);
        this.autoScalingGroups = autoScalingGroupsCopy;
    }

    public DeploymentGroupInfo withAutoScalingGroups(AutoScalingGroup ... autoScalingGroups) {
        if (this.getAutoScalingGroups() == null) {
            this.setAutoScalingGroups(new ArrayList<AutoScalingGroup>(autoScalingGroups.length));
        }
        for (AutoScalingGroup value : autoScalingGroups) {
            this.getAutoScalingGroups().add(value);
        }
        return this;
    }

    public DeploymentGroupInfo withAutoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
        if (autoScalingGroups == null) {
            this.autoScalingGroups = null;
        } else {
            ListWithAutoConstructFlag autoScalingGroupsCopy = new ListWithAutoConstructFlag(autoScalingGroups.size());
            autoScalingGroupsCopy.addAll(autoScalingGroups);
            this.autoScalingGroups = autoScalingGroupsCopy;
        }
        return this;
    }

    public String getServiceRoleArn() {
        return this.serviceRoleArn;
    }

    public void setServiceRoleArn(String serviceRoleArn) {
        this.serviceRoleArn = serviceRoleArn;
    }

    public DeploymentGroupInfo withServiceRoleArn(String serviceRoleArn) {
        this.serviceRoleArn = serviceRoleArn;
        return this;
    }

    public RevisionLocation getTargetRevision() {
        return this.targetRevision;
    }

    public void setTargetRevision(RevisionLocation targetRevision) {
        this.targetRevision = targetRevision;
    }

    public DeploymentGroupInfo withTargetRevision(RevisionLocation targetRevision) {
        this.targetRevision = targetRevision;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: " + this.getApplicationName() + ",");
        }
        if (this.getDeploymentGroupId() != null) {
            sb.append("DeploymentGroupId: " + this.getDeploymentGroupId() + ",");
        }
        if (this.getDeploymentGroupName() != null) {
            sb.append("DeploymentGroupName: " + this.getDeploymentGroupName() + ",");
        }
        if (this.getDeploymentConfigName() != null) {
            sb.append("DeploymentConfigName: " + this.getDeploymentConfigName() + ",");
        }
        if (this.getEc2TagFilters() != null) {
            sb.append("Ec2TagFilters: " + this.getEc2TagFilters() + ",");
        }
        if (this.getAutoScalingGroups() != null) {
            sb.append("AutoScalingGroups: " + this.getAutoScalingGroups() + ",");
        }
        if (this.getServiceRoleArn() != null) {
            sb.append("ServiceRoleArn: " + this.getServiceRoleArn() + ",");
        }
        if (this.getTargetRevision() != null) {
            sb.append("TargetRevision: " + this.getTargetRevision());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentGroupId() == null ? 0 : this.getDeploymentGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentGroupName() == null ? 0 : this.getDeploymentGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentConfigName() == null ? 0 : this.getDeploymentConfigName().hashCode());
        hashCode = 31 * hashCode + (this.getEc2TagFilters() == null ? 0 : this.getEc2TagFilters().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingGroups() == null ? 0 : this.getAutoScalingGroups().hashCode());
        hashCode = 31 * hashCode + (this.getServiceRoleArn() == null ? 0 : this.getServiceRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getTargetRevision() == null ? 0 : this.getTargetRevision().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentGroupInfo)) {
            return false;
        }
        DeploymentGroupInfo other = (DeploymentGroupInfo)obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getDeploymentGroupId() == null ^ this.getDeploymentGroupId() == null) {
            return false;
        }
        if (other.getDeploymentGroupId() != null && !other.getDeploymentGroupId().equals(this.getDeploymentGroupId())) {
            return false;
        }
        if (other.getDeploymentGroupName() == null ^ this.getDeploymentGroupName() == null) {
            return false;
        }
        if (other.getDeploymentGroupName() != null && !other.getDeploymentGroupName().equals(this.getDeploymentGroupName())) {
            return false;
        }
        if (other.getDeploymentConfigName() == null ^ this.getDeploymentConfigName() == null) {
            return false;
        }
        if (other.getDeploymentConfigName() != null && !other.getDeploymentConfigName().equals(this.getDeploymentConfigName())) {
            return false;
        }
        if (other.getEc2TagFilters() == null ^ this.getEc2TagFilters() == null) {
            return false;
        }
        if (other.getEc2TagFilters() != null && !other.getEc2TagFilters().equals(this.getEc2TagFilters())) {
            return false;
        }
        if (other.getAutoScalingGroups() == null ^ this.getAutoScalingGroups() == null) {
            return false;
        }
        if (other.getAutoScalingGroups() != null && !other.getAutoScalingGroups().equals(this.getAutoScalingGroups())) {
            return false;
        }
        if (other.getServiceRoleArn() == null ^ this.getServiceRoleArn() == null) {
            return false;
        }
        if (other.getServiceRoleArn() != null && !other.getServiceRoleArn().equals(this.getServiceRoleArn())) {
            return false;
        }
        if (other.getTargetRevision() == null ^ this.getTargetRevision() == null) {
            return false;
        }
        return other.getTargetRevision() == null || other.getTargetRevision().equals(this.getTargetRevision());
    }

    public DeploymentGroupInfo clone() {
        try {
            return (DeploymentGroupInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

