/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.codedeploy.model.DeploymentStatus;
import com.amazonaws.services.codedeploy.model.TimeRange;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListDeploymentsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String applicationName;
    private String deploymentGroupName;
    private ListWithAutoConstructFlag<String> includeOnlyStatuses;
    private TimeRange createTimeRange;
    private String nextToken;

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public ListDeploymentsRequest withApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public String getDeploymentGroupName() {
        return this.deploymentGroupName;
    }

    public void setDeploymentGroupName(String deploymentGroupName) {
        this.deploymentGroupName = deploymentGroupName;
    }

    public ListDeploymentsRequest withDeploymentGroupName(String deploymentGroupName) {
        this.deploymentGroupName = deploymentGroupName;
        return this;
    }

    public List<String> getIncludeOnlyStatuses() {
        if (this.includeOnlyStatuses == null) {
            this.includeOnlyStatuses = new ListWithAutoConstructFlag();
            this.includeOnlyStatuses.setAutoConstruct(true);
        }
        return this.includeOnlyStatuses;
    }

    public void setIncludeOnlyStatuses(Collection<String> includeOnlyStatuses) {
        if (includeOnlyStatuses == null) {
            this.includeOnlyStatuses = null;
            return;
        }
        ListWithAutoConstructFlag includeOnlyStatusesCopy = new ListWithAutoConstructFlag(includeOnlyStatuses.size());
        includeOnlyStatusesCopy.addAll(includeOnlyStatuses);
        this.includeOnlyStatuses = includeOnlyStatusesCopy;
    }

    public ListDeploymentsRequest withIncludeOnlyStatuses(String ... includeOnlyStatuses) {
        if (this.getIncludeOnlyStatuses() == null) {
            this.setIncludeOnlyStatuses(new ArrayList<String>(includeOnlyStatuses.length));
        }
        for (String value : includeOnlyStatuses) {
            this.getIncludeOnlyStatuses().add(value);
        }
        return this;
    }

    public ListDeploymentsRequest withIncludeOnlyStatuses(Collection<String> includeOnlyStatuses) {
        if (includeOnlyStatuses == null) {
            this.includeOnlyStatuses = null;
        } else {
            ListWithAutoConstructFlag includeOnlyStatusesCopy = new ListWithAutoConstructFlag(includeOnlyStatuses.size());
            includeOnlyStatusesCopy.addAll(includeOnlyStatuses);
            this.includeOnlyStatuses = includeOnlyStatusesCopy;
        }
        return this;
    }

    public ListDeploymentsRequest withIncludeOnlyStatuses(DeploymentStatus ... includeOnlyStatuses) {
        ArrayList<String> includeOnlyStatusesCopy = new ArrayList<String>(includeOnlyStatuses.length);
        for (DeploymentStatus member : includeOnlyStatuses) {
            includeOnlyStatusesCopy.add(member.toString());
        }
        if (this.getIncludeOnlyStatuses() == null) {
            this.setIncludeOnlyStatuses(includeOnlyStatusesCopy);
        } else {
            this.getIncludeOnlyStatuses().addAll(includeOnlyStatusesCopy);
        }
        return this;
    }

    public TimeRange getCreateTimeRange() {
        return this.createTimeRange;
    }

    public void setCreateTimeRange(TimeRange createTimeRange) {
        this.createTimeRange = createTimeRange;
    }

    public ListDeploymentsRequest withCreateTimeRange(TimeRange createTimeRange) {
        this.createTimeRange = createTimeRange;
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public ListDeploymentsRequest withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: " + this.getApplicationName() + ",");
        }
        if (this.getDeploymentGroupName() != null) {
            sb.append("DeploymentGroupName: " + this.getDeploymentGroupName() + ",");
        }
        if (this.getIncludeOnlyStatuses() != null) {
            sb.append("IncludeOnlyStatuses: " + this.getIncludeOnlyStatuses() + ",");
        }
        if (this.getCreateTimeRange() != null) {
            sb.append("CreateTimeRange: " + this.getCreateTimeRange() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentGroupName() == null ? 0 : this.getDeploymentGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeOnlyStatuses() == null ? 0 : this.getIncludeOnlyStatuses().hashCode());
        hashCode = 31 * hashCode + (this.getCreateTimeRange() == null ? 0 : this.getCreateTimeRange().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentsRequest)) {
            return false;
        }
        ListDeploymentsRequest other = (ListDeploymentsRequest)obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getDeploymentGroupName() == null ^ this.getDeploymentGroupName() == null) {
            return false;
        }
        if (other.getDeploymentGroupName() != null && !other.getDeploymentGroupName().equals(this.getDeploymentGroupName())) {
            return false;
        }
        if (other.getIncludeOnlyStatuses() == null ^ this.getIncludeOnlyStatuses() == null) {
            return false;
        }
        if (other.getIncludeOnlyStatuses() != null && !other.getIncludeOnlyStatuses().equals(this.getIncludeOnlyStatuses())) {
            return false;
        }
        if (other.getCreateTimeRange() == null ^ this.getCreateTimeRange() == null) {
            return false;
        }
        if (other.getCreateTimeRange() != null && !other.getCreateTimeRange().equals(this.getCreateTimeRange())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    @Override
    public ListDeploymentsRequest clone() {
        return (ListDeploymentsRequest)super.clone();
    }
}

