/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.datapipeline.model.Field;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReportTaskProgressRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String taskId;
    private ListWithAutoConstructFlag<Field> fields;

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public ReportTaskProgressRequest withTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    public List<Field> getFields() {
        if (this.fields == null) {
            this.fields = new ListWithAutoConstructFlag();
            this.fields.setAutoConstruct(true);
        }
        return this.fields;
    }

    public void setFields(Collection<Field> fields) {
        if (fields == null) {
            this.fields = null;
            return;
        }
        ListWithAutoConstructFlag fieldsCopy = new ListWithAutoConstructFlag(fields.size());
        fieldsCopy.addAll(fields);
        this.fields = fieldsCopy;
    }

    public ReportTaskProgressRequest withFields(Field ... fields) {
        if (this.getFields() == null) {
            this.setFields(new ArrayList<Field>(fields.length));
        }
        for (Field value : fields) {
            this.getFields().add(value);
        }
        return this;
    }

    public ReportTaskProgressRequest withFields(Collection<Field> fields) {
        if (fields == null) {
            this.fields = null;
        } else {
            ListWithAutoConstructFlag fieldsCopy = new ListWithAutoConstructFlag(fields.size());
            fieldsCopy.addAll(fields);
            this.fields = fieldsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTaskId() != null) {
            sb.append("TaskId: " + this.getTaskId() + ",");
        }
        if (this.getFields() != null) {
            sb.append("Fields: " + this.getFields());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTaskId() == null ? 0 : this.getTaskId().hashCode());
        hashCode = 31 * hashCode + (this.getFields() == null ? 0 : this.getFields().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportTaskProgressRequest)) {
            return false;
        }
        ReportTaskProgressRequest other = (ReportTaskProgressRequest)obj;
        if (other.getTaskId() == null ^ this.getTaskId() == null) {
            return false;
        }
        if (other.getTaskId() != null && !other.getTaskId().equals(this.getTaskId())) {
            return false;
        }
        if (other.getFields() == null ^ this.getFields() == null) {
            return false;
        }
        return other.getFields() == null || other.getFields().equals(this.getFields());
    }

    @Override
    public ReportTaskProgressRequest clone() {
        return (ReportTaskProgressRequest)super.clone();
    }
}

