/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ContainerInstance
implements Serializable,
Cloneable {
    private String containerInstanceArn;
    private String ec2InstanceId;
    private ListWithAutoConstructFlag<Resource> remainingResources;
    private ListWithAutoConstructFlag<Resource> registeredResources;
    private String status;
    private Boolean agentConnected;

    public String getContainerInstanceArn() {
        return this.containerInstanceArn;
    }

    public void setContainerInstanceArn(String containerInstanceArn) {
        this.containerInstanceArn = containerInstanceArn;
    }

    public ContainerInstance withContainerInstanceArn(String containerInstanceArn) {
        this.containerInstanceArn = containerInstanceArn;
        return this;
    }

    public String getEc2InstanceId() {
        return this.ec2InstanceId;
    }

    public void setEc2InstanceId(String ec2InstanceId) {
        this.ec2InstanceId = ec2InstanceId;
    }

    public ContainerInstance withEc2InstanceId(String ec2InstanceId) {
        this.ec2InstanceId = ec2InstanceId;
        return this;
    }

    public List<Resource> getRemainingResources() {
        if (this.remainingResources == null) {
            this.remainingResources = new ListWithAutoConstructFlag();
            this.remainingResources.setAutoConstruct(true);
        }
        return this.remainingResources;
    }

    public void setRemainingResources(Collection<Resource> remainingResources) {
        if (remainingResources == null) {
            this.remainingResources = null;
            return;
        }
        ListWithAutoConstructFlag remainingResourcesCopy = new ListWithAutoConstructFlag(remainingResources.size());
        remainingResourcesCopy.addAll(remainingResources);
        this.remainingResources = remainingResourcesCopy;
    }

    public ContainerInstance withRemainingResources(Resource ... remainingResources) {
        if (this.getRemainingResources() == null) {
            this.setRemainingResources(new ArrayList<Resource>(remainingResources.length));
        }
        for (Resource value : remainingResources) {
            this.getRemainingResources().add(value);
        }
        return this;
    }

    public ContainerInstance withRemainingResources(Collection<Resource> remainingResources) {
        if (remainingResources == null) {
            this.remainingResources = null;
        } else {
            ListWithAutoConstructFlag remainingResourcesCopy = new ListWithAutoConstructFlag(remainingResources.size());
            remainingResourcesCopy.addAll(remainingResources);
            this.remainingResources = remainingResourcesCopy;
        }
        return this;
    }

    public List<Resource> getRegisteredResources() {
        if (this.registeredResources == null) {
            this.registeredResources = new ListWithAutoConstructFlag();
            this.registeredResources.setAutoConstruct(true);
        }
        return this.registeredResources;
    }

    public void setRegisteredResources(Collection<Resource> registeredResources) {
        if (registeredResources == null) {
            this.registeredResources = null;
            return;
        }
        ListWithAutoConstructFlag registeredResourcesCopy = new ListWithAutoConstructFlag(registeredResources.size());
        registeredResourcesCopy.addAll(registeredResources);
        this.registeredResources = registeredResourcesCopy;
    }

    public ContainerInstance withRegisteredResources(Resource ... registeredResources) {
        if (this.getRegisteredResources() == null) {
            this.setRegisteredResources(new ArrayList<Resource>(registeredResources.length));
        }
        for (Resource value : registeredResources) {
            this.getRegisteredResources().add(value);
        }
        return this;
    }

    public ContainerInstance withRegisteredResources(Collection<Resource> registeredResources) {
        if (registeredResources == null) {
            this.registeredResources = null;
        } else {
            ListWithAutoConstructFlag registeredResourcesCopy = new ListWithAutoConstructFlag(registeredResources.size());
            registeredResourcesCopy.addAll(registeredResources);
            this.registeredResources = registeredResourcesCopy;
        }
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public ContainerInstance withStatus(String status) {
        this.status = status;
        return this;
    }

    public Boolean isAgentConnected() {
        return this.agentConnected;
    }

    public void setAgentConnected(Boolean agentConnected) {
        this.agentConnected = agentConnected;
    }

    public ContainerInstance withAgentConnected(Boolean agentConnected) {
        this.agentConnected = agentConnected;
        return this;
    }

    public Boolean getAgentConnected() {
        return this.agentConnected;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContainerInstanceArn() != null) {
            sb.append("ContainerInstanceArn: " + this.getContainerInstanceArn() + ",");
        }
        if (this.getEc2InstanceId() != null) {
            sb.append("Ec2InstanceId: " + this.getEc2InstanceId() + ",");
        }
        if (this.getRemainingResources() != null) {
            sb.append("RemainingResources: " + this.getRemainingResources() + ",");
        }
        if (this.getRegisteredResources() != null) {
            sb.append("RegisteredResources: " + this.getRegisteredResources() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.isAgentConnected() != null) {
            sb.append("AgentConnected: " + this.isAgentConnected());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContainerInstanceArn() == null ? 0 : this.getContainerInstanceArn().hashCode());
        hashCode = 31 * hashCode + (this.getEc2InstanceId() == null ? 0 : this.getEc2InstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getRemainingResources() == null ? 0 : this.getRemainingResources().hashCode());
        hashCode = 31 * hashCode + (this.getRegisteredResources() == null ? 0 : this.getRegisteredResources().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.isAgentConnected() == null ? 0 : this.isAgentConnected().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerInstance)) {
            return false;
        }
        ContainerInstance other = (ContainerInstance)obj;
        if (other.getContainerInstanceArn() == null ^ this.getContainerInstanceArn() == null) {
            return false;
        }
        if (other.getContainerInstanceArn() != null && !other.getContainerInstanceArn().equals(this.getContainerInstanceArn())) {
            return false;
        }
        if (other.getEc2InstanceId() == null ^ this.getEc2InstanceId() == null) {
            return false;
        }
        if (other.getEc2InstanceId() != null && !other.getEc2InstanceId().equals(this.getEc2InstanceId())) {
            return false;
        }
        if (other.getRemainingResources() == null ^ this.getRemainingResources() == null) {
            return false;
        }
        if (other.getRemainingResources() != null && !other.getRemainingResources().equals(this.getRemainingResources())) {
            return false;
        }
        if (other.getRegisteredResources() == null ^ this.getRegisteredResources() == null) {
            return false;
        }
        if (other.getRegisteredResources() != null && !other.getRegisteredResources().equals(this.getRegisteredResources())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.isAgentConnected() == null ^ this.isAgentConnected() == null) {
            return false;
        }
        return other.isAgentConnected() == null || other.isAgentConnected().equals(this.isAgentConnected());
    }

    public ContainerInstance clone() {
        try {
            return (ContainerInstance)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

