/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.ListGeoLocationsRequest;
import com.amazonaws.transform.Marshaller;

public class ListGeoLocationsRequestMarshaller
implements Marshaller<Request<ListGeoLocationsRequest>, ListGeoLocationsRequest> {
    @Override
    public Request<ListGeoLocationsRequest> marshall(ListGeoLocationsRequest listGeoLocationsRequest) {
        if (listGeoLocationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListGeoLocationsRequest> request = new DefaultRequest<ListGeoLocationsRequest>(listGeoLocationsRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2013-04-01/geolocations?startcontinentcode={StartContinentCode}&startcountrycode={StartCountryCode}&startsubdivisioncode={StartSubdivisionCode}&maxitems={MaxItems}";
        uriResourcePath = uriResourcePath.replace("{StartContinentCode}", this.getString(listGeoLocationsRequest.getStartContinentCode()));
        uriResourcePath = uriResourcePath.replace("{StartCountryCode}", this.getString(listGeoLocationsRequest.getStartCountryCode()));
        uriResourcePath = uriResourcePath.replace("{StartSubdivisionCode}", this.getString(listGeoLocationsRequest.getStartSubdivisionCode()));
        uriResourcePath = uriResourcePath.replace("{MaxItems}", this.getString(listGeoLocationsRequest.getMaxItems()));
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

