/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.ContainerOverride;
import com.amazonaws.services.ecs.model.RunTaskRequest;
import com.amazonaws.services.ecs.model.TaskOverride;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class RunTaskRequestMarshaller
implements Marshaller<Request<RunTaskRequest>, RunTaskRequest> {
    @Override
    public Request<RunTaskRequest> marshall(RunTaskRequest runTaskRequest) {
        if (runTaskRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RunTaskRequest> request = new DefaultRequest<RunTaskRequest>(runTaskRequest, "AmazonECS");
        String target = "AmazonEC2ContainerServiceV20141113.RunTask";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            TaskOverride overrides;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (runTaskRequest.getCluster() != null) {
                jsonWriter.key("cluster").value(runTaskRequest.getCluster());
            }
            if (runTaskRequest.getTaskDefinition() != null) {
                jsonWriter.key("taskDefinition").value(runTaskRequest.getTaskDefinition());
            }
            if ((overrides = runTaskRequest.getOverrides()) != null) {
                jsonWriter.key("overrides");
                jsonWriter.object();
                ListWithAutoConstructFlag containerOverridesList = (ListWithAutoConstructFlag)overrides.getContainerOverrides();
                if (!(containerOverridesList == null || containerOverridesList.isAutoConstruct() && containerOverridesList.isEmpty())) {
                    jsonWriter.key("containerOverrides");
                    jsonWriter.array();
                    for (ContainerOverride containerOverridesListValue : containerOverridesList) {
                        ListWithAutoConstructFlag commandList;
                        if (containerOverridesListValue == null) continue;
                        jsonWriter.object();
                        if (containerOverridesListValue.getName() != null) {
                            jsonWriter.key("name").value(containerOverridesListValue.getName());
                        }
                        if (!((commandList = (ListWithAutoConstructFlag)containerOverridesListValue.getCommand()) == null || commandList.isAutoConstruct() && commandList.isEmpty())) {
                            jsonWriter.key("command");
                            jsonWriter.array();
                            for (String commandListValue : commandList) {
                                if (commandListValue == null) continue;
                                jsonWriter.value(commandListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            if (runTaskRequest.getCount() != null) {
                jsonWriter.key("count").value(runTaskRequest.getCount());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

