/*
 * Decompiled with CFR 0.152.
 */
package com.gu.logback.appender.kinesis;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.LayoutBase;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.retry.PredefinedRetryPolicies;
import com.amazonaws.retry.RetryPolicy;
import com.amazonaws.services.kinesis.AmazonKinesisAsyncClient;
import com.amazonaws.services.kinesis.model.DescribeStreamResult;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.services.kinesis.model.ResourceNotFoundException;
import com.amazonaws.services.kinesis.model.StreamStatus;
import com.gu.logback.appender.kinesis.AppenderConstants;
import com.gu.logback.appender.kinesis.helpers.AsyncPutCallStatsReporter;
import com.gu.logback.appender.kinesis.helpers.BlockFastProducerPolicy;
import com.gu.logback.appender.kinesis.helpers.CustomCredentialsProviderChain;
import com.gu.logback.appender.kinesis.helpers.Validator;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class KinesisAppender
extends AppenderBase<ILoggingEvent> {
    private String encoding = "UTF-8";
    private int maxRetries = 3;
    private int bufferSize = 2000;
    private int threadCount = 20;
    private int shutdownTimeout = 30;
    private String endpoint;
    private String region;
    private String streamName;
    private String roleToAssumeArn;
    private boolean initializationFailed = false;
    private BlockingQueue<Runnable> taskBuffer;
    private AmazonKinesisAsyncClient kinesisClient;
    private AsyncPutCallStatsReporter asyncCallHander;
    private LayoutBase layout;
    private AWSCredentialsProvider credentials = new CustomCredentialsProviderChain();

    public LayoutBase getLayout() {
        return this.layout;
    }

    public void setLayout(LayoutBase layout) {
        this.layout = layout;
    }

    public void start() {
        boolean regionProvided;
        if (this.layout == null) {
            this.initializationFailed = true;
            this.addError("Invalid configuration - No layout for appender: " + this.name);
            return;
        }
        if (this.streamName == null) {
            this.initializationFailed = true;
            this.addError("Invalid configuration - streamName cannot be null for appender: " + this.name);
            return;
        }
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setMaxErrorRetry(this.maxRetries);
        clientConfiguration.setRetryPolicy(new RetryPolicy(PredefinedRetryPolicies.DEFAULT_RETRY_CONDITION, PredefinedRetryPolicies.DEFAULT_BACKOFF_STRATEGY, this.maxRetries, true));
        clientConfiguration.setUserAgent("kinesis-logback-appender/1.1.0");
        LinkedBlockingDeque<Runnable> taskBuffer = new LinkedBlockingDeque<Runnable>(this.bufferSize);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(this.threadCount, this.threadCount, 30L, TimeUnit.SECONDS, taskBuffer, new BlockFastProducerPolicy());
        threadPoolExecutor.prestartAllCoreThreads();
        this.kinesisClient = new AmazonKinesisAsyncClient(this.credentials, clientConfiguration, (ExecutorService)threadPoolExecutor);
        boolean bl = regionProvided = !Validator.isBlank(this.region);
        if (!regionProvided) {
            this.region = AppenderConstants.DEFAULT_REGION;
        }
        if (!Validator.isBlank(this.endpoint)) {
            if (regionProvided) {
                this.addError("Received configuration for both region as well as Amazon Kinesis endpoint. (" + this.endpoint + ") will be used as endpoint instead of default endpoint for region (" + this.region + ")");
            }
            this.kinesisClient.setEndpoint(this.endpoint, "kinesis", this.region);
        } else {
            this.kinesisClient.setRegion(Region.getRegion((Regions)Regions.fromName((String)this.region)));
        }
        DescribeStreamResult describeResult = null;
        try {
            describeResult = this.kinesisClient.describeStream(this.streamName);
            String streamStatus = describeResult.getStreamDescription().getStreamStatus();
            if (!StreamStatus.ACTIVE.name().equals(streamStatus) && !StreamStatus.UPDATING.name().equals(streamStatus)) {
                this.initializationFailed = true;
                this.addError("Stream " + this.streamName + " is not ready (in active/updating status) for appender: " + this.name);
            }
        }
        catch (ResourceNotFoundException rnfe) {
            this.initializationFailed = true;
            this.addError("Stream " + this.streamName + " doesn't exist for appender: " + this.name, rnfe);
        }
        this.asyncCallHander = new AsyncPutCallStatsReporter(this);
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ThreadPoolExecutor threadpool = (ThreadPoolExecutor)this.kinesisClient.getExecutorService();
        threadpool.shutdown();
        BlockingQueue<Runnable> taskQueue = threadpool.getQueue();
        int bufferSizeBeforeShutdown = threadpool.getQueue().size();
        boolean gracefulShutdown = true;
        try {
            gracefulShutdown = threadpool.awaitTermination(this.shutdownTimeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException bufferSizeAfterShutdown) {
        }
        finally {
            int bufferSizeAfterShutdown = taskQueue.size();
            if (!gracefulShutdown || bufferSizeAfterShutdown > 0) {
                String errorMsg = "Kinesis Log4J Appender (" + this.name + ") waited for " + this.shutdownTimeout + " seconds before terminating but could send only " + (bufferSizeAfterShutdown - bufferSizeBeforeShutdown) + " logevents, it failed to send " + bufferSizeAfterShutdown + " pending log events from it's processing queue";
                this.addError(errorMsg);
            }
        }
        this.kinesisClient.shutdown();
    }

    protected void append(ILoggingEvent logEvent) {
        if (this.initializationFailed) {
            this.addError("Check the configuration and whether the configured stream " + this.streamName + " exists and is active. Failed to initialize kinesis logback appender: " + this.name);
            return;
        }
        try {
            String message = this.layout.doLayout((Object)logEvent);
            this.putMessage(message);
        }
        catch (Exception e) {
            this.addError("Failed to schedule log entry for publishing into Kinesis stream: " + this.streamName, e);
        }
    }

    private void putMessage(String message) throws Exception {
        ByteBuffer data = ByteBuffer.wrap(message.getBytes(this.encoding));
        this.kinesisClient.putRecordAsync(new PutRecordRequest().withPartitionKey(UUID.randomUUID().toString()).withStreamName(this.streamName).withData(data), (AsyncHandler)this.asyncCallHander);
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String streamName) {
        Validator.validate(!Validator.isBlank(streamName), "streamName cannot be blank");
        this.streamName = streamName.trim();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String charset) {
        Validator.validate(!Validator.isBlank(this.encoding), "encoding cannot be blank");
        this.encoding = this.encoding.trim();
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        Validator.validate(maxRetries > 0, "maxRetries must be > 0");
        this.maxRetries = maxRetries;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        Validator.validate(bufferSize > 0, "bufferSize must be >0");
        this.bufferSize = bufferSize;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int parallelCount) {
        Validator.validate(parallelCount > 0, "threadCount must be >0");
        this.threadCount = parallelCount;
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public void setShutdownTimeout(int shutdownTimeout) {
        Validator.validate(shutdownTimeout > 0, "shutdownTimeout must be >0");
        this.shutdownTimeout = shutdownTimeout;
    }

    public int getTaskBufferSize() {
        return this.taskBuffer.size();
    }

    public String getRoleToAssumeArn() {
        return this.roleToAssumeArn;
    }

    public void setRoleToAssumeArn(String roleToAssumeArn) {
        this.roleToAssumeArn = roleToAssumeArn;
        if (!Validator.isBlank(roleToAssumeArn)) {
            String sessionId = "session" + Math.random();
            STSAssumeRoleSessionCredentialsProvider remoteAccountCredentials = new STSAssumeRoleSessionCredentialsProvider(this.credentials, roleToAssumeArn, sessionId);
            this.credentials = remoteAccountCredentials;
        }
    }

    public void setCredentialsProvider(AWSCredentialsProvider credentialsProvider) {
        this.credentials = credentialsProvider;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }
}

