/*
 * Decompiled with CFR 0.152.
 */
package com.gu.logback.appender.kinesis.helpers;

import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.kinesisfirehose.model.PutRecordRequest;
import com.amazonaws.services.kinesisfirehose.model.PutRecordResult;
import com.gu.logback.appender.kinesis.FirehoseAppender;

public class FirehoseStatsReporter
implements AsyncHandler<PutRecordRequest, PutRecordResult> {
    private final String appenderName;
    private long successfulRequestCount;
    private long failedRequestCount;
    private final FirehoseAppender<?> appender;

    public FirehoseStatsReporter(FirehoseAppender<?> appender) {
        this.appenderName = appender.getStreamName();
        this.appender = appender;
    }

    public void onError(Exception exception) {
        ++this.failedRequestCount;
        this.appender.addError("Failed to publish a log entry to kinesis using appender: " + this.appenderName, exception);
    }

    public void onSuccess(PutRecordRequest request, PutRecordResult result) {
        ++this.successfulRequestCount;
    }
}

