/*
 * Decompiled with CFR 0.152.
 */
package com.gu.logback.appender.kinesis;

import ch.qos.logback.core.spi.DeferredProcessingAware;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.kinesisfirehose.AmazonKinesisFirehoseAsyncClient;
import com.amazonaws.services.kinesisfirehose.model.DeliveryStreamStatus;
import com.amazonaws.services.kinesisfirehose.model.DescribeDeliveryStreamRequest;
import com.amazonaws.services.kinesisfirehose.model.DescribeDeliveryStreamResult;
import com.amazonaws.services.kinesisfirehose.model.PutRecordRequest;
import com.amazonaws.services.kinesisfirehose.model.Record;
import com.amazonaws.services.kinesisfirehose.model.ResourceNotFoundException;
import com.gu.logback.appender.kinesis.BaseKinesisAppender;
import com.gu.logback.appender.kinesis.helpers.FirehoseStatsReporter;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;

public class FirehoseAppender<Event extends DeferredProcessingAware>
extends BaseKinesisAppender<Event, AmazonKinesisFirehoseAsyncClient> {
    private FirehoseStatsReporter asyncCallHandler = new FirehoseStatsReporter(this);

    @Override
    protected AmazonKinesisFirehoseAsyncClient createClient(AWSCredentialsProvider credentials, ClientConfiguration configuration, ThreadPoolExecutor executor) {
        return new AmazonKinesisFirehoseAsyncClient(credentials, configuration, (ExecutorService)executor);
    }

    @Override
    protected void validateStreamName(AmazonKinesisFirehoseAsyncClient client, String streamName) {
        try {
            DescribeDeliveryStreamResult describeResult = ((AmazonKinesisFirehoseAsyncClient)this.getClient()).describeDeliveryStream(new DescribeDeliveryStreamRequest().withDeliveryStreamName(streamName));
            String streamStatus = describeResult.getDeliveryStreamDescription().getDeliveryStreamStatus();
            if (!DeliveryStreamStatus.ACTIVE.name().equals(streamStatus)) {
                this.setInitializationFailed(true);
                this.addError("Stream " + streamName + " is not ready (in active status) for appender: " + this.name);
            }
        }
        catch (ResourceNotFoundException rnfe) {
            this.setInitializationFailed(true);
            this.addError("Stream " + streamName + " doesn't exist for appender: " + this.name, rnfe);
        }
        catch (AmazonServiceException ase) {
            this.setInitializationFailed(true);
            this.addError("Error connecting to AWS to verify stream " + streamName + " for appender: " + this.name, ase);
        }
    }

    @Override
    protected void putMessage(String message) throws Exception {
        ByteBuffer data = ByteBuffer.wrap(message.getBytes(this.getEncoding()));
        ((AmazonKinesisFirehoseAsyncClient)this.getClient()).putRecordAsync(new PutRecordRequest().withDeliveryStreamName(this.getStreamName()).withRecord(new Record().withData(data)), (AsyncHandler)this.asyncCallHandler);
    }
}

