/*
 * Decompiled with CFR 0.152.
 */
package com.gu.logback.appender.kinesis;

import ch.qos.logback.core.spi.DeferredProcessingAware;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.kinesis.AmazonKinesisAsyncClient;
import com.amazonaws.services.kinesis.model.DescribeStreamResult;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.services.kinesis.model.ResourceNotFoundException;
import com.amazonaws.services.kinesis.model.StreamStatus;
import com.gu.logback.appender.kinesis.BaseKinesisAppender;
import com.gu.logback.appender.kinesis.helpers.KinesisStatsReporter;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;

public class KinesisAppender<Event extends DeferredProcessingAware>
extends BaseKinesisAppender<Event, AmazonKinesisAsyncClient> {
    private KinesisStatsReporter asyncCallHandler = new KinesisStatsReporter(this);

    @Override
    protected AmazonKinesisAsyncClient createClient(AWSCredentialsProvider credentials, ClientConfiguration configuration, ThreadPoolExecutor executor) {
        return new AmazonKinesisAsyncClient(credentials, configuration, (ExecutorService)executor);
    }

    @Override
    protected void validateStreamName(AmazonKinesisAsyncClient client, String streamName) {
        try {
            DescribeStreamResult describeResult = ((AmazonKinesisAsyncClient)this.getClient()).describeStream(streamName);
            String streamStatus = describeResult.getStreamDescription().getStreamStatus();
            if (!StreamStatus.ACTIVE.name().equals(streamStatus) && !StreamStatus.UPDATING.name().equals(streamStatus)) {
                this.setInitializationFailed(true);
                this.addError("Stream " + streamName + " is not ready (in active/updating status) for appender: " + this.name);
            }
        }
        catch (ResourceNotFoundException rnfe) {
            this.setInitializationFailed(true);
            this.addError("Stream " + streamName + " doesn't exist for appender: " + this.name, rnfe);
        }
        catch (AmazonServiceException ase) {
            this.setInitializationFailed(true);
            this.addError("Error connecting to AWS to verify stream " + streamName + " for appender: " + this.name, ase);
        }
    }

    @Override
    protected void putMessage(String message) throws Exception {
        ByteBuffer data = ByteBuffer.wrap(message.getBytes(this.getEncoding()));
        ((AmazonKinesisAsyncClient)this.getClient()).putRecordAsync(new PutRecordRequest().withPartitionKey(UUID.randomUUID().toString()).withStreamName(this.getStreamName()).withData(data), (AsyncHandler)this.asyncCallHandler);
    }
}

