/*
 * Decompiled with CFR 0.152.
 */
package com.gu.logback.appender.kinesis.helpers;

import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.amazonaws.services.kinesis.model.PutRecordResult;
import com.gu.logback.appender.kinesis.KinesisAppender;

public class KinesisStatsReporter
implements AsyncHandler<PutRecordRequest, PutRecordResult> {
    private final String appenderName;
    private long successfulRequestCount;
    private long failedRequestCount;
    private final KinesisAppender<?> appender;

    public KinesisStatsReporter(KinesisAppender<?> appender) {
        this.appenderName = appender.getStreamName();
        this.appender = appender;
    }

    public void onError(Exception exception) {
        ++this.failedRequestCount;
        this.appender.addError("Failed to publish a log entry to kinesis using appender: " + this.appenderName, exception);
    }

    public void onSuccess(PutRecordRequest request, PutRecordResult result) {
        ++this.successfulRequestCount;
    }
}

