/*
 * Decompiled with CFR 0.152.
 */
package com.gu.logback.appender.kinesis;

import ch.qos.logback.core.spi.DeferredProcessingAware;
import com.gu.logback.appender.kinesis.BaseKinesisAppender;
import com.gu.logback.appender.kinesis.helpers.KinesisStatsReporter;
import java.net.URI;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.BiConsumer;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClientBuilder;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse;
import software.amazon.awssdk.services.kinesis.model.PutRecordRequest;
import software.amazon.awssdk.services.kinesis.model.ResourceNotFoundException;
import software.amazon.awssdk.services.kinesis.model.StreamStatus;

public class KinesisAppender<Event extends DeferredProcessingAware>
extends BaseKinesisAppender<Event, KinesisAsyncClient> {
    private KinesisStatsReporter asyncCallHandler = new KinesisStatsReporter(this);

    @Override
    protected KinesisAsyncClient createClient(AwsCredentialsProvider credentials, ClientOverrideConfiguration configuration, ThreadPoolExecutor executor, Region region, Optional<URI> endpointOverride) {
        KinesisAsyncClientBuilder builder = (KinesisAsyncClientBuilder)((KinesisAsyncClientBuilder)((KinesisAsyncClientBuilder)((KinesisAsyncClientBuilder)KinesisAsyncClient.builder().credentialsProvider(credentials)).region(region)).overrideConfiguration(configuration)).asyncConfiguration(b -> b.advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, (Object)executor));
        endpointOverride.ifPresent(endpoint -> {
            KinesisAsyncClientBuilder cfr_ignored_0 = (KinesisAsyncClientBuilder)builder.endpointOverride(endpoint);
        });
        return (KinesisAsyncClient)builder.build();
    }

    @Override
    protected void validateStreamName(KinesisAsyncClient client, String streamName) {
        try {
            DescribeStreamResponse describeResult = (DescribeStreamResponse)((KinesisAsyncClient)this.getClient()).describeStream(b -> {
                DescribeStreamRequest cfr_ignored_0 = (DescribeStreamRequest)b.streamName(streamName).build();
            }).get();
            StreamStatus streamStatus = describeResult.streamDescription().streamStatus();
            if (!StreamStatus.ACTIVE.equals((Object)streamStatus) && !StreamStatus.UPDATING.equals((Object)streamStatus)) {
                this.setInitializationFailed(true);
                this.addError("Stream " + streamName + " is not ready (in active/updating status) for appender: " + this.name);
            }
        }
        catch (InterruptedException ie) {
            this.setInitializationFailed(true);
            this.addError("Interrupted while attempting to describe " + streamName, ie);
        }
        catch (ExecutionException ee) {
            this.setInitializationFailed(true);
            this.addError("Error executing the operation", ee);
        }
        catch (ResourceNotFoundException rnfe) {
            this.setInitializationFailed(true);
            this.addError("Stream " + streamName + " doesn't exist for appender: " + this.name, rnfe);
        }
        catch (AwsServiceException ase) {
            this.setInitializationFailed(true);
            this.addError("Error connecting to AWS to verify stream " + streamName + " for appender: " + this.name, ase);
        }
    }

    @Override
    protected void putMessage(String message) throws Exception {
        SdkBytes data = SdkBytes.fromByteArray((byte[])message.getBytes(this.getEncoding()));
        ((KinesisAsyncClient)this.getClient()).putRecord(builder -> {
            PutRecordRequest cfr_ignored_0 = (PutRecordRequest)builder.partitionKey(UUID.randomUUID().toString()).streamName(this.getStreamName()).data(data).build();
        }).whenCompleteAsync((BiConsumer)this.asyncCallHandler);
    }
}

