/*
 * Decompiled with CFR 0.152.
 */
package com.gu.logback.appender.kinesis;

import ch.qos.logback.core.spi.DeferredProcessingAware;
import com.gu.logback.appender.kinesis.BaseKinesisAppender;
import com.gu.logback.appender.kinesis.helpers.FirehoseStatsReporter;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.BiConsumer;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.firehose.FirehoseAsyncClient;
import software.amazon.awssdk.services.firehose.FirehoseAsyncClientBuilder;
import software.amazon.awssdk.services.firehose.model.DeliveryStreamStatus;
import software.amazon.awssdk.services.firehose.model.DescribeDeliveryStreamRequest;
import software.amazon.awssdk.services.firehose.model.DescribeDeliveryStreamResponse;
import software.amazon.awssdk.services.firehose.model.PutRecordRequest;
import software.amazon.awssdk.services.firehose.model.Record;
import software.amazon.awssdk.services.firehose.model.ResourceNotFoundException;

public class FirehoseAppender<Event extends DeferredProcessingAware>
extends BaseKinesisAppender<Event, FirehoseAsyncClient> {
    private FirehoseStatsReporter asyncCallHandler = new FirehoseStatsReporter(this);

    @Override
    protected FirehoseAsyncClient createClient(AwsCredentialsProvider credentials, ClientOverrideConfiguration configuration, ThreadPoolExecutor executor, Region region, Optional<URI> endpointOverride) {
        FirehoseAsyncClientBuilder builder = (FirehoseAsyncClientBuilder)((FirehoseAsyncClientBuilder)((FirehoseAsyncClientBuilder)((FirehoseAsyncClientBuilder)FirehoseAsyncClient.builder().credentialsProvider(credentials)).asyncConfiguration(b -> b.advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, (Object)executor))).overrideConfiguration(configuration)).region(region);
        endpointOverride.ifPresent(endpoint -> {
            FirehoseAsyncClientBuilder cfr_ignored_0 = (FirehoseAsyncClientBuilder)builder.endpointOverride(endpoint);
        });
        return (FirehoseAsyncClient)builder.build();
    }

    @Override
    protected void validateStreamName(FirehoseAsyncClient client, String streamName) {
        try {
            DescribeDeliveryStreamResponse describeResponse = (DescribeDeliveryStreamResponse)((FirehoseAsyncClient)this.getClient()).describeDeliveryStream(b -> {
                DescribeDeliveryStreamRequest cfr_ignored_0 = (DescribeDeliveryStreamRequest)b.deliveryStreamName(streamName).build();
            }).get();
            DeliveryStreamStatus streamStatus = describeResponse.deliveryStreamDescription().deliveryStreamStatus();
            if (!DeliveryStreamStatus.ACTIVE.equals((Object)streamStatus)) {
                this.setInitializationFailed(true);
                this.addError("Stream " + streamName + " is not ready (in active status) for appender: " + this.name);
            }
        }
        catch (InterruptedException ie) {
            this.setInitializationFailed(true);
            this.addError("Interrupted while attempting to describe " + streamName, ie);
        }
        catch (ExecutionException ee) {
            this.setInitializationFailed(true);
            this.addError("Error executing the operation", ee);
        }
        catch (ResourceNotFoundException rnfe) {
            this.setInitializationFailed(true);
            this.addError("Stream " + streamName + " doesn't exist for appender: " + this.name, rnfe);
        }
        catch (AwsServiceException ase) {
            this.setInitializationFailed(true);
            this.addError("Error connecting to AWS to verify stream " + streamName + " for appender: " + this.name, ase);
        }
    }

    @Override
    protected void putMessage(String message) throws Exception {
        SdkBytes data = SdkBytes.fromByteArray((byte[])message.getBytes(this.getEncoding()));
        ((FirehoseAsyncClient)this.getClient()).putRecord(builder -> {
            PutRecordRequest cfr_ignored_0 = (PutRecordRequest)builder.deliveryStreamName(this.getStreamName()).record(b -> {
                Record cfr_ignored_0 = (Record)b.data(data).build();
            }).build();
        }).whenCompleteAsync((BiConsumer)this.asyncCallHandler);
    }
}

