/*
 * Decompiled with CFR 0.152.
 */
package com.gu.logback.appender.kinesis;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import com.gu.logback.appender.kinesis.AppenderConstants;
import com.gu.logback.appender.kinesis.helpers.BlockFastProducerPolicy;
import com.gu.logback.appender.kinesis.helpers.NamedThreadFactory;
import com.gu.logback.appender.kinesis.helpers.Validator;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public abstract class BaseKinesisAppender<Event extends DeferredProcessingAware, Client extends SdkClient>
extends AppenderBase<Event> {
    private String encoding = "UTF-8";
    private int maxRetries = 3;
    private int bufferSize = 2000;
    private int threadCount = 20;
    private int shutdownTimeout = 30;
    private String endpoint;
    private String region;
    private String streamName;
    private String roleToAssumeArn;
    private boolean initializationFailed = false;
    private BlockingQueue<Runnable> taskBuffer;
    private ThreadPoolExecutor threadPoolExecutor;
    private LayoutBase<Event> layout;
    private AwsCredentialsProvider credentials = DefaultCredentialsProvider.create();
    private Client client;

    public void start() {
        Optional<URI> endpointOverride;
        if (this.layout == null) {
            this.initializationFailed = true;
            this.addError("Invalid configuration - No layout for appender: " + this.name);
            return;
        }
        if (this.streamName == null) {
            this.initializationFailed = true;
            this.addError("Invalid configuration - streamName cannot be null for appender: " + this.name);
            return;
        }
        ClientOverrideConfiguration clientConfiguration = (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().retryPolicy(RetryPolicy.defaultRetryPolicy().toBuilder().numRetries(Integer.valueOf(this.maxRetries)).build()).putHeader("User-Agent", "kinesis-logback-appender/2.0.0").build();
        LinkedBlockingDeque<Runnable> taskBuffer = new LinkedBlockingDeque<Runnable>(this.bufferSize);
        this.threadPoolExecutor = new ThreadPoolExecutor(this.threadCount, this.threadCount, 30L, TimeUnit.SECONDS, taskBuffer, this.setupThreadFactory(), new BlockFastProducerPolicy());
        this.threadPoolExecutor.prestartAllCoreThreads();
        if (!Validator.isBlank(this.endpoint)) {
            if (!Validator.isBlank(this.region)) {
                this.addError("Received configuration for both region as well as Amazon Kinesis endpoint. (" + this.endpoint + ") will be used as endpoint instead of default endpoint for region (" + this.region + ")");
            }
            endpointOverride = Optional.of(URI.create(this.endpoint));
        } else {
            endpointOverride = Optional.empty();
        }
        this.client = this.createClient(this.credentials, clientConfiguration, this.threadPoolExecutor, this.findRegion(), endpointOverride);
        this.validateStreamName(this.client, this.streamName);
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.threadPoolExecutor.shutdown();
        BlockingQueue<Runnable> taskQueue = this.threadPoolExecutor.getQueue();
        int bufferSizeBeforeShutdown = this.threadPoolExecutor.getQueue().size();
        boolean gracefulShutdown = true;
        try {
            gracefulShutdown = this.threadPoolExecutor.awaitTermination(this.shutdownTimeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException bufferSizeAfterShutdown) {
        }
        finally {
            int bufferSizeAfterShutdown = taskQueue.size();
            if (!gracefulShutdown || bufferSizeAfterShutdown > 0) {
                String errorMsg = "Kinesis Log4J Appender (" + this.name + ") waited for " + this.shutdownTimeout + " seconds before terminating but could send only " + (bufferSizeAfterShutdown - bufferSizeBeforeShutdown) + " logevents, it failed to send " + bufferSizeAfterShutdown + " pending log events from it's processing queue";
                this.addError(errorMsg);
            }
        }
        this.client.close();
    }

    protected abstract void validateStreamName(Client var1, String var2);

    protected void append(Event logEvent) {
        if (this.initializationFailed) {
            this.addError("Check the configuration and whether the configured stream " + this.streamName + " exists and is active. Failed to initialize kinesis logback appender: " + this.name);
            return;
        }
        try {
            String message = this.layout.doLayout(logEvent);
            this.putMessage(message);
        }
        catch (Exception e) {
            this.addError("Failed to schedule log entry for publishing into Kinesis stream: " + this.streamName, e);
        }
    }

    protected abstract void putMessage(String var1) throws Exception;

    private ThreadFactory setupThreadFactory() {
        return new NamedThreadFactory(((Object)((Object)this)).getClass().getSimpleName() + "[" + this.streamName + "]-");
    }

    private Region findRegion() {
        boolean regionProvided;
        boolean bl = regionProvided = !Validator.isBlank(this.region);
        if (!regionProvided) {
            return Region.of((String)AppenderConstants.DEFAULT_REGION);
        }
        return Region.of((String)this.region);
    }

    public LayoutBase<Event> getLayout() {
        return this.layout;
    }

    public void setLayout(LayoutBase<Event> layout) {
        this.layout = layout;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String streamName) {
        Validator.validate(!Validator.isBlank(streamName), "streamName cannot be blank");
        this.streamName = streamName.trim();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String charset) {
        Validator.validate(!Validator.isBlank(charset), "encoding cannot be blank");
        this.encoding = charset.trim();
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        Validator.validate(maxRetries > 0, "maxRetries must be > 0");
        this.maxRetries = maxRetries;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        Validator.validate(bufferSize > 0, "bufferSize must be >0");
        this.bufferSize = bufferSize;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int parallelCount) {
        Validator.validate(parallelCount > 0, "threadCount must be >0");
        this.threadCount = parallelCount;
    }

    public int getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    public void setShutdownTimeout(int shutdownTimeout) {
        Validator.validate(shutdownTimeout > 0, "shutdownTimeout must be >0");
        this.shutdownTimeout = shutdownTimeout;
    }

    public int getTaskBufferSize() {
        return this.taskBuffer.size();
    }

    public String getRoleToAssumeArn() {
        return this.roleToAssumeArn;
    }

    public void setRoleToAssumeArn(String roleToAssumeArn) {
        this.roleToAssumeArn = roleToAssumeArn;
        if (!Validator.isBlank(roleToAssumeArn)) {
            String sessionId = "session" + Math.random();
            StsAssumeRoleCredentialsProvider remoteAccountCredentials = StsAssumeRoleCredentialsProvider.builder().refreshRequest(builder -> {
                AssumeRoleRequest cfr_ignored_0 = (AssumeRoleRequest)builder.roleArn(roleToAssumeArn).roleSessionName(sessionId).build();
            }).build();
            this.credentials = remoteAccountCredentials;
        }
    }

    public AwsCredentialsProvider getCredentialsProvider() {
        return this.credentials;
    }

    public void setCredentialsProvider(AwsCredentialsProvider credentialsProvider) {
        this.credentials = credentialsProvider;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    protected void setInitializationFailed(boolean initializationFailed) {
        this.initializationFailed = initializationFailed;
    }

    protected abstract Client createClient(AwsCredentialsProvider var1, ClientOverrideConfiguration var2, ThreadPoolExecutor var3, Region var4, Optional<URI> var5);

    protected Client getClient() {
        return this.client;
    }
}

