/*
 * Decompiled with CFR 0.152.
 */
package com.gu.logback.appender.kinesis.helpers;

import com.gu.logback.appender.kinesis.FirehoseAppender;
import java.util.function.BiConsumer;
import software.amazon.awssdk.services.firehose.model.PutRecordResponse;

public final class FirehoseStatsReporter
implements BiConsumer<PutRecordResponse, Throwable> {
    private final String appenderName;
    private long successfulRequestCount;
    private long failedRequestCount;
    private final FirehoseAppender<?> appender;

    public FirehoseStatsReporter(FirehoseAppender<?> appender) {
        this.appenderName = appender.getStreamName();
        this.appender = appender;
    }

    @Override
    public final void accept(PutRecordResponse response, Throwable exception) {
        if (exception != null) {
            ++this.failedRequestCount;
            this.appender.addError("Failed to publish a log entry to kinesis using appender: " + this.appenderName, exception);
        } else {
            ++this.successfulRequestCount;
        }
    }

    public final long getSuccessfulRequestCount() {
        return this.successfulRequestCount;
    }

    public final long getFailedRequestCount() {
        return this.failedRequestCount;
    }
}

