/*
 * Decompiled with CFR 0.152.
 */
package com.gu.pandomainauth.action;

import com.gu.pandomainauth.PanDomain$;
import com.gu.pandomainauth.PublicSettings$;
import com.gu.pandomainauth.action.AuthActions;
import com.gu.pandomainauth.action.AuthActions$;
import com.gu.pandomainauth.model.Authenticated;
import com.gu.pandomainauth.model.AuthenticatedUser;
import com.gu.pandomainauth.model.AuthenticationStatus;
import com.gu.pandomainauth.model.Expired;
import com.gu.pandomainauth.model.GracePeriod;
import com.gu.pandomainauth.model.NotAuthenticated$;
import com.gu.pandomainauth.model.NotAuthorized;
import com.gu.pandomainauth.model.User;
import com.gu.pandomainauth.service.CookieUtils$;
import com.gu.pandomainauth.service.Google2FAGroupChecker;
import com.gu.pandomainauth.service.GoogleAuth;
import com.gu.pandomainauth.service.GoogleAuthException;
import com.gu.pandomainauth.service.GoogleAuthException$;
import com.gu.pandomainauth.service.LegacyCookie$;
import play.api.Logger$;
import play.api.Play$;
import play.api.mvc.Cookie;
import play.api.mvc.Cookie$;
import play.api.mvc.DiscardingCookie;
import play.api.mvc.DiscardingCookie$;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.mvc.Results$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public abstract class AuthActions$class {
    public static boolean cacheValidation(AuthActions $this) {
        return false;
    }

    public static long apiGracePeriod(AuthActions $this) {
        return 0L;
    }

    public static Future sendForAuth(AuthActions $this, RequestHeader request, Option email) {
        String antiForgeryToken = $this.GoogleAuth().generateAntiForgeryToken();
        return $this.GoogleAuth().redirectToGoogle(antiForgeryToken, (Option<String>)email, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global(), Play$.MODULE$.current(), request).map((Function1)new Serializable($this, antiForgeryToken, request){
            private final /* synthetic */ AuthActions $outer;
            private final String antiForgeryToken$1;
            private final RequestHeader request$2;

            public final Result apply(Result res) {
                String originUrl = this.request$2.uri();
                return res.withSession(this.request$2.session().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.ANTI_FORGERY_KEY()), (Object)this.antiForgeryToken$1)).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.$outer.LOGIN_ORIGIN_KEY()), (Object)originUrl)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.antiForgeryToken$1 = antiForgeryToken$1;
                this.request$2 = request$2;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
    }

    public static Option sendForAuth$default$2(AuthActions $this) {
        return None$.MODULE$;
    }

    public static boolean checkMultifactor(AuthActions $this, AuthenticatedUser authedUser) {
        return BoxesRunTime.unboxToBoolean((Object)$this.multifactorChecker().map((Function1)new Serializable($this, authedUser){
            private final AuthenticatedUser authedUser$8;

            public final boolean apply(Google2FAGroupChecker x$2) {
                return x$2.checkMultifactor(this.authedUser$8);
            }
            {
                this.authedUser$8 = authedUser$8;
            }
        }).getOrElse((Function0)new Serializable($this){

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }));
    }

    public static Result showUnauthedMessage(AuthActions $this, String message, RequestHeader request) {
        Logger$.MODULE$.info((Function0)new Serializable($this, message){
            private final String message$1;

            public final String apply() {
                return this.message$1;
            }
            {
                this.message$1 = message$1;
            }
        });
        return Results$.MODULE$.Forbidden();
    }

    public static String invalidUserMessage(AuthActions $this, AuthenticatedUser claimedAuth) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"user ", " not valid for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{claimedAuth.user().email(), $this.system()}));
    }

    public static Future processGoogleCallback(AuthActions $this, RequestHeader request) {
        String token = (String)request.session().get($this.ANTI_FORGERY_KEY()).getOrElse((Function0)new Serializable($this){

            public final Nothing$ apply() {
                throw new GoogleAuthException("missing anti forgery token", GoogleAuthException$.MODULE$.$lessinit$greater$default$2());
            }
        });
        String originalUrl = (String)request.session().get($this.LOGIN_ORIGIN_KEY()).getOrElse((Function0)new Serializable($this){

            public final Nothing$ apply() {
                throw new GoogleAuthException("missing original url", GoogleAuthException$.MODULE$.$lessinit$greater$default$2());
            }
        });
        Option<Cookie> existingCookie = $this.readCookie(request);
        return $this.GoogleAuth().validatedUserIdentity(token, request, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global(), Play$.MODULE$.current()).map((Function1)new Serializable($this, originalUrl, existingCookie, request){
            private final /* synthetic */ AuthActions $outer;
            private final String originalUrl$1;
            private final Option existingCookie$1;
            private final RequestHeader request$3;

            public final Result apply(AuthenticatedUser claimedAuth) {
                Option option;
                block7: {
                    Result result;
                    AuthenticatedUser authenticatedUser;
                    block6: {
                        block5: {
                            option = this.existingCookie$1;
                            if (!(option instanceof Some)) break block5;
                            Some some = (Some)option;
                            Cookie c = (Cookie)some.x();
                            AuthenticatedUser existingAuth = LegacyCookie$.MODULE$.parseCookieData(c.value(), this.$outer.settings().secret());
                            Logger$.MODULE$.debug((Function0)new Serializable(this){

                                public final String apply() {
                                    return "user re-authed, merging auth data";
                                }
                            });
                            String x$3 = this.$outer.system();
                            Set x$4 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$outer.system()}));
                            boolean x$5 = this.$outer.checkMultifactor(claimedAuth);
                            User x$6 = claimedAuth.copy$default$1();
                            long x$7 = claimedAuth.copy$default$4();
                            authenticatedUser = claimedAuth.copy(x$6, x$3, x$4, x$7, x$5);
                            break block6;
                        }
                        if (!None$.MODULE$.equals(option)) break block7;
                        Logger$.MODULE$.debug((Function0)new Serializable(this){

                            public final String apply() {
                                return "fresh user login";
                            }
                        });
                        boolean x$8 = this.$outer.checkMultifactor(claimedAuth);
                        User x$9 = claimedAuth.copy$default$1();
                        String x$10 = claimedAuth.copy$default$2();
                        Set x$11 = claimedAuth.copy$default$3();
                        long x$12 = claimedAuth.copy$default$4();
                        authenticatedUser = claimedAuth.copy(x$9, x$10, x$11, x$12, x$8);
                    }
                    AuthenticatedUser authedUserData = authenticatedUser;
                    if (this.$outer.validateUser(authedUserData)) {
                        List<Cookie> updatedCookies = this.$outer.generateCookies(authedUserData);
                        result = Results$.MODULE$.Redirect(this.originalUrl$1, Results$.MODULE$.Redirect$default$2(), Results$.MODULE$.Redirect$default$3()).withCookies(updatedCookies).withSession(this.request$3.session().$minus(this.$outer.ANTI_FORGERY_KEY()).$minus(this.$outer.LOGIN_ORIGIN_KEY()));
                    } else {
                        result = this.$outer.showUnauthedMessage(this.$outer.invalidUserMessage(claimedAuth), this.request$3);
                    }
                    return result;
                }
                throw new MatchError((Object)option);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.originalUrl$1 = originalUrl$1;
                this.existingCookie$1 = existingCookie$1;
                this.request$3 = request$3;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
    }

    public static Result processLogout(AuthActions $this, RequestHeader request) {
        return $this.flushCookie($this.showUnauthedMessage("logged out", request));
    }

    public static Option readCookie(AuthActions $this, RequestHeader request) {
        return request.cookies().get(PublicSettings$.MODULE$.cookieName());
    }

    public static List generateCookies(AuthActions $this, AuthenticatedUser authedUser) {
        Cookie[] cookieArray = new Cookie[2];
        String x$13 = PublicSettings$.MODULE$.cookieName();
        String x$14 = LegacyCookie$.MODULE$.generateCookieData(authedUser, $this.settings().secret());
        Some x$15 = new Some((Object)$this.domain());
        boolean x$16 = true;
        boolean x$17 = true;
        Option x$18 = Cookie$.MODULE$.apply$default$3();
        String x$19 = Cookie$.MODULE$.apply$default$4();
        cookieArray[0] = new Cookie(x$13, x$14, x$18, x$19, (Option)x$15, x$16, x$17);
        String x$20 = PublicSettings$.MODULE$.assymCookieName();
        String x$21 = CookieUtils$.MODULE$.generateCookieData(authedUser, $this.settings().privateKey());
        Some x$22 = new Some((Object)$this.domain());
        boolean x$23 = true;
        boolean x$24 = true;
        Option x$25 = Cookie$.MODULE$.apply$default$3();
        String x$26 = Cookie$.MODULE$.apply$default$4();
        cookieArray[1] = new Cookie(x$20, x$21, x$25, x$26, (Option)x$22, x$23, x$24);
        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])cookieArray));
    }

    public static Result includeSystemInCookie(AuthActions $this, AuthenticatedUser authedUser, Result result) {
        Set x$27 = (Set)authedUser.authenticatedIn().$plus((Object)$this.system());
        User x$28 = authedUser.copy$default$1();
        String x$29 = authedUser.copy$default$2();
        long x$30 = authedUser.copy$default$4();
        boolean x$31 = authedUser.copy$default$5();
        AuthenticatedUser updatedAuth = authedUser.copy(x$28, x$29, x$27, x$30, x$31);
        List<Cookie> updatedCookies = $this.generateCookies(updatedAuth);
        return result.withCookies(updatedCookies);
    }

    public static Result flushCookie(AuthActions $this, Result result) {
        String x$32 = PublicSettings$.MODULE$.cookieName();
        Some x$33 = new Some((Object)$this.domain());
        boolean x$34 = true;
        String x$35 = DiscardingCookie$.MODULE$.apply$default$2();
        DiscardingCookie clearCookie = new DiscardingCookie(x$32, x$35, (Option)x$33, x$34);
        String x$36 = PublicSettings$.MODULE$.assymCookieName();
        Some x$37 = new Some((Object)$this.domain());
        boolean x$38 = true;
        String x$39 = DiscardingCookie$.MODULE$.apply$default$2();
        DiscardingCookie clearAssymCookie = new DiscardingCookie(x$36, x$39, (Option)x$37, x$38);
        return result.discardingCookies((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DiscardingCookie[]{clearCookie, clearAssymCookie}));
    }

    public static AuthenticationStatus extractAuth(AuthActions $this, RequestHeader request) {
        return (AuthenticationStatus)$this.readCookie(request).map((Function1)new Serializable($this){
            private final /* synthetic */ AuthActions $outer;

            public final AuthenticationStatus apply(Cookie cookie) {
                AuthenticationStatus authenticationStatus;
                Expired expired;
                AuthenticatedUser authedUser;
                AuthenticationStatus authenticationStatus2 = PanDomain$.MODULE$.authStatusWithLegacyCheck(cookie.value(), this.$outer.settings().publicKey(), this.$outer.settings().secret());
                if (authenticationStatus2 instanceof Expired && (authedUser = (expired = (Expired)authenticationStatus2).authedUser()).isInGracePeriod(this.$outer.apiGracePeriod())) {
                    authenticationStatus = new GracePeriod(authedUser);
                } else if (authenticationStatus2 instanceof Authenticated) {
                    Authenticated authenticated = (Authenticated)authenticationStatus2;
                    AuthenticatedUser authedUser2 = authenticated.authedUser();
                    authenticationStatus = this.$outer.cacheValidation() && authedUser2.authenticatedIn().apply((Object)this.$outer.system()) ? authenticated : (this.$outer.validateUser(authedUser2) ? authenticated : new NotAuthorized(authedUser2));
                } else {
                    authenticationStatus = authenticationStatus2;
                }
                return authenticationStatus;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable($this){

            public final NotAuthenticated$ apply() {
                return NotAuthenticated$.MODULE$;
            }
        });
    }

    public static void $init$(AuthActions $this) {
        $this.com$gu$pandomainauth$action$AuthActions$_setter_$GoogleAuth_$eq(new GoogleAuth($this.settings().googleAuthSettings(), $this.system(), $this.authCallbackUrl()));
        $this.com$gu$pandomainauth$action$AuthActions$_setter_$multifactorChecker_$eq($this.settings().google2FAGroupSettings().map((Function1)new AuthActions$.anonfun.1($this)));
        $this.com$gu$pandomainauth$action$AuthActions$_setter_$LOGIN_ORIGIN_KEY_$eq("loginOriginUrl");
        $this.com$gu$pandomainauth$action$AuthActions$_setter_$ANTI_FORGERY_KEY_$eq("antiForgeryToken");
    }
}

