/*
 * Decompiled with CFR 0.152.
 */
package com.gu.scanamo.error;

import cats.data.NonEmptyList;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.gu.scanamo.error.DynamoReadError;
import com.gu.scanamo.error.InvalidPropertiesError;
import com.gu.scanamo.error.MissingProperty$;
import com.gu.scanamo.error.NoPropertyOfType;
import com.gu.scanamo.error.PropertyReadError;
import com.gu.scanamo.error.TypeCoercionError;
import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;

public final class DynamoReadError$ {
    public static DynamoReadError$ MODULE$;

    static {
        new DynamoReadError$();
    }

    public String describe(DynamoReadError d) {
        String string;
        DynamoReadError dynamoReadError = d;
        if (dynamoReadError instanceof InvalidPropertiesError) {
            InvalidPropertiesError invalidPropertiesError = (InvalidPropertiesError)dynamoReadError;
            NonEmptyList<PropertyReadError> problems = invalidPropertiesError.errors();
            string = ((TraversableOnce)problems.toList().map((Function1 & java.io.Serializable & Serializable)p -> new StringBuilder(4).append("'").append(p.name()).append("': ").append(MODULE$.describe(p.problem())).toString(), List$.MODULE$.canBuildFrom())).mkString(", ");
        } else if (dynamoReadError instanceof NoPropertyOfType) {
            NoPropertyOfType noPropertyOfType = (NoPropertyOfType)dynamoReadError;
            String propertyType = noPropertyOfType.propertyType();
            AttributeValue actual = noPropertyOfType.actual();
            string = new StringBuilder(22).append("not of type: '").append(propertyType).append("' was '").append(actual).append("'").toString();
        } else if (dynamoReadError instanceof TypeCoercionError) {
            TypeCoercionError typeCoercionError = (TypeCoercionError)dynamoReadError;
            Throwable e = typeCoercionError.t();
            string = new StringBuilder(40).append("could not be converted to desired type: ").append(e).toString();
        } else if (MissingProperty$.MODULE$.equals(dynamoReadError)) {
            string = "missing";
        } else {
            throw new MatchError((Object)dynamoReadError);
        }
        return string;
    }

    private DynamoReadError$() {
        MODULE$ = this;
    }
}

