/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.AnyMethodrefConstant;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.AllParameterVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.ParameterVisitor;
import proguard.evaluation.PartialEvaluator;
import proguard.evaluation.TracedStack;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TracedReferenceValue;
import proguard.evaluation.value.TypedReferenceValueFactory;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.info.NoExternalSideEffectMethodMarker;
import proguard.optimize.info.ParameterEscapeMarker;
import proguard.optimize.info.ParameterUsageMarker;
import proguard.optimize.info.SideEffectClassChecker;
import proguard.optimize.info.SideEffectInstructionChecker;
import proguard.optimize.info.SideEffectMethodMarker;
import proguard.util.ArrayUtil;

public class InstructionUsageMarker
implements AttributeVisitor {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_RESULTS = false;
    private final PartialEvaluator partialEvaluator;
    private final boolean runPartialEvaluator;
    private final PartialEvaluator simplePartialEvaluator = new PartialEvaluator((ValueFactory)new TypedReferenceValueFactory());
    private final SideEffectInstructionChecker sideEffectInstructionChecker = new SideEffectInstructionChecker(true, true);
    private final MyParameterUsageMarker parameterUsageMarker = new MyParameterUsageMarker();
    private final MyInitialUsageMarker initialUsageMarker = new MyInitialUsageMarker();
    private final MyProducerMarker producerMarker = new MyProducerMarker();
    private final MyVariableInitializationMarker variableInitializationMarker = new MyVariableInitializationMarker();
    private final MyStackConsistencyMarker stackConsistencyMarker = new MyStackConsistencyMarker();
    private final MyExtraPushPopInstructionMarker extraPushPopInstructionMarker = new MyExtraPushPopInstructionMarker();
    private InstructionOffsetValue[] reverseDependencies = new InstructionOffsetValue[8096];
    private boolean[][] stacksNecessaryAfter = new boolean[8096][16];
    private boolean[][] stacksUnwantedBefore = new boolean[8096][16];
    private boolean[] instructionsNecessary = new boolean[8096];
    private boolean[] extraPushPopInstructionsNecessary = new boolean[8096];
    private int maxMarkedOffset;

    public InstructionUsageMarker() {
        this(new PartialEvaluator(), true);
    }

    public InstructionUsageMarker(PartialEvaluator partialEvaluator, boolean runPartialEvaluator) {
        this.partialEvaluator = partialEvaluator;
        this.runPartialEvaluator = runPartialEvaluator;
    }

    public boolean isTraced(int instructionOffset) {
        return this.partialEvaluator.isTraced(instructionOffset);
    }

    public InstructionVisitor tracedInstructionFilter(InstructionVisitor instructionVisitor) {
        return this.partialEvaluator.tracedInstructionFilter(instructionVisitor);
    }

    public InstructionVisitor tracedInstructionFilter(boolean traced, InstructionVisitor instructionVisitor) {
        return this.partialEvaluator.tracedInstructionFilter(traced, instructionVisitor);
    }

    public boolean isInstructionNecessary(int instructionOffset) {
        return this.instructionsNecessary[instructionOffset];
    }

    public boolean isExtraPushPopInstructionNecessary(int instructionOffset) {
        return this.extraPushPopInstructionsNecessary[instructionOffset];
    }

    public InstructionVisitor necessaryInstructionFilter(InstructionVisitor instructionVisitor) {
        return this.necessaryInstructionFilter(true, instructionVisitor);
    }

    public InstructionVisitor necessaryInstructionFilter(boolean necessary, InstructionVisitor instructionVisitor) {
        return new MyNecessaryInstructionFilter(necessary, instructionVisitor);
    }

    public TracedStack getStackBefore(int instructionOffset) {
        return this.partialEvaluator.getStackBefore(instructionOffset);
    }

    public TracedStack getStackAfter(int instructionOffset) {
        return this.partialEvaluator.getStackAfter(instructionOffset);
    }

    public boolean isStackEntryUnwantedBefore(int instructionOffset, int stackIndex) {
        return this.stacksUnwantedBefore[instructionOffset][stackIndex];
    }

    public boolean isStackEntriesPresentBefore(int instructionOffset, int stackIndex1, int stackIndex2) {
        boolean present1 = this.isStackEntryPresentBefore(instructionOffset, stackIndex1);
        boolean present2 = this.isStackEntryPresentBefore(instructionOffset, stackIndex2);
        return present1 || present2;
    }

    public boolean isStackEntryPresentBefore(int instructionOffset, int stackIndex) {
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(instructionOffset);
        InstructionOffsetValue producerOffsets = tracedStack.getBottomProducerValue(stackIndex).instructionOffsetValue();
        return this.isAnyStackEntryNecessaryAfter(producerOffsets, stackIndex);
    }

    public boolean isStackEntriesNecessaryAfter(int instructionOffset, int stackIndex1, int stackIndex2) {
        boolean present1 = this.isStackEntryNecessaryAfter(instructionOffset, stackIndex1);
        boolean present2 = this.isStackEntryNecessaryAfter(instructionOffset, stackIndex2);
        return present1 || present2;
    }

    public boolean isAnyStackEntryNecessaryAfter(InstructionOffsetValue instructionOffsets, int stackIndex) {
        int offsetCount = instructionOffsets.instructionOffsetCount();
        for (int offsetIndex = 0; offsetIndex < offsetCount; ++offsetIndex) {
            if (!instructionOffsets.isExceptionHandler(offsetIndex) && !this.isStackEntryNecessaryAfter(instructionOffsets.instructionOffset(offsetIndex), stackIndex)) continue;
            return true;
        }
        return false;
    }

    public boolean isStackEntryNecessaryAfter(int instructionOffset, int stackIndex) {
        return (instructionOffset & 0x20000000) != 0 || this.stacksNecessaryAfter[instructionOffset][stackIndex];
    }

    public InstructionOffsetValue branchTargets(int instructionOffset) {
        return this.partialEvaluator.branchTargets(instructionOffset);
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException ex) {
            System.err.println("Unexpected error while marking instruction usage after partial evaluation:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + ex.getClass().getName() + "] (" + ex.getMessage() + ")");
            throw ex;
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        Instruction instruction;
        int offset;
        this.initializeNecessary(codeAttribute);
        if (this.runPartialEvaluator) {
            this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        }
        this.simplePartialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        int codeLength = codeAttribute.u4codeLength;
        this.maxMarkedOffset = -1;
        codeAttribute.instructionsAccept(clazz, method, this.partialEvaluator.tracedInstructionFilter((InstructionVisitor)this.parameterUsageMarker));
        codeAttribute.instructionsAccept(clazz, method, this.partialEvaluator.tracedInstructionFilter((InstructionVisitor)this.initialUsageMarker));
        while (this.maxMarkedOffset >= 0) {
            offset = this.maxMarkedOffset;
            this.maxMarkedOffset = offset - 1;
            if (!this.partialEvaluator.isTraced(offset)) continue;
            if (this.isInstructionNecessary(offset)) {
                instruction = InstructionFactory.create((byte[])codeAttribute.code, (int)offset);
                instruction.accept(clazz, method, codeAttribute, offset, (InstructionVisitor)this.producerMarker);
                this.markReverseDependencies(offset);
            }
            this.markStraddlingBranches(offset, this.partialEvaluator.branchTargets(offset), true);
            this.markStraddlingBranches(offset, this.partialEvaluator.branchOrigins(offset), false);
        }
        codeAttribute.instructionsAccept(clazz, method, this.necessaryInstructionFilter(this.variableInitializationMarker));
        this.maxMarkedOffset = codeLength - 1;
        while (this.maxMarkedOffset >= 0) {
            offset = this.maxMarkedOffset;
            this.maxMarkedOffset = offset - 1;
            if (!this.partialEvaluator.isTraced(offset)) continue;
            instruction = InstructionFactory.create((byte[])codeAttribute.code, (int)offset);
            instruction.accept(clazz, method, codeAttribute, offset, (InstructionVisitor)this.stackConsistencyMarker);
            this.markStraddlingBranches(offset, this.partialEvaluator.branchTargets(offset), true);
            this.markStraddlingBranches(offset, this.partialEvaluator.branchOrigins(offset), false);
        }
        this.maxMarkedOffset = codeLength - 1;
        while (this.maxMarkedOffset >= 0) {
            offset = this.maxMarkedOffset;
            this.maxMarkedOffset = offset - 1;
            if (!this.partialEvaluator.isTraced(offset) || this.isInstructionNecessary(offset)) continue;
            instruction = InstructionFactory.create((byte[])codeAttribute.code, (int)offset);
            instruction.accept(clazz, method, codeAttribute, offset, (InstructionVisitor)this.extraPushPopInstructionMarker);
            this.markStraddlingBranches(offset, this.partialEvaluator.branchTargets(offset), true);
            this.markStraddlingBranches(offset, this.partialEvaluator.branchOrigins(offset), false);
        }
    }

    private void markVariableProducers(int consumerOffset, int variableIndex) {
        InstructionOffsetValue producerOffsets = this.partialEvaluator.getVariablesBefore(consumerOffset).getProducerValue(variableIndex).instructionOffsetValue();
        if (producerOffsets != null) {
            int offsetCount = producerOffsets.instructionOffsetCount();
            for (int offsetIndex = 0; offsetIndex < offsetCount; ++offsetIndex) {
                if (producerOffsets.isMethodParameter(offsetIndex) || producerOffsets.isExceptionHandler(offsetIndex)) continue;
                int offset = producerOffsets.instructionOffset(offsetIndex);
                this.markInstruction(offset);
            }
        }
    }

    private InstructionOffsetValue markVariableInitializersBefore(int consumerOffset, int variableIndex, InstructionOffsetValue visitedOffsets) {
        if (visitedOffsets == null || !visitedOffsets.contains(consumerOffset)) {
            visitedOffsets = visitedOffsets == null ? new InstructionOffsetValue(consumerOffset) : visitedOffsets.add(consumerOffset);
            InstructionOffsetValue producerOffsets = this.simplePartialEvaluator.getVariablesBefore(consumerOffset).getProducerValue(variableIndex).instructionOffsetValue();
            int offsetCount = producerOffsets.instructionOffsetCount();
            for (int offsetIndex = 0; offsetIndex < offsetCount; ++offsetIndex) {
                if (producerOffsets.isMethodParameter(offsetIndex) || producerOffsets.isExceptionHandler(offsetIndex)) continue;
                int producerOffset = producerOffsets.instructionOffset(offsetIndex);
                visitedOffsets = this.markVariableInitializersAfter(producerOffset, variableIndex, visitedOffsets);
            }
        }
        return visitedOffsets;
    }

    private InstructionOffsetValue markVariableInitializersAfter(int producerOffset, int variableIndex, InstructionOffsetValue visitedOffsets) {
        if (!this.isInstructionNecessary(producerOffset)) {
            if (this.isVariableInitialization(producerOffset, variableIndex)) {
                this.markInstruction(producerOffset);
            } else {
                visitedOffsets = this.markVariableInitializersBefore(producerOffset, variableIndex, visitedOffsets);
            }
        }
        return visitedOffsets;
    }

    private void markStackProducers(Clazz clazz, int consumerOffset, Instruction consumer) {
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(consumerOffset);
        int stackSize = tracedStack.size();
        int popCount = consumer.stackPopCount(clazz);
        for (int stackIndex = stackSize - popCount; stackIndex < stackSize; ++stackIndex) {
            this.markStackEntryProducers(consumerOffset, stackIndex, true);
        }
    }

    private void conditionallyMarkStackEntryProducers(int consumerOffset, int consumerTopStackIndex, int producerTopStackIndex) {
        int consumerBottomStackIndex = this.partialEvaluator.getStackAfter(consumerOffset).size() - consumerTopStackIndex - 1;
        if (this.isStackEntryNecessaryAfter(consumerOffset, consumerBottomStackIndex)) {
            int producerBottomStackIndex = this.partialEvaluator.getStackBefore(consumerOffset).size() - producerTopStackIndex - 1;
            this.markStackEntryProducers(consumerOffset, producerBottomStackIndex, true);
        }
    }

    private void markStackEntryProducers(int consumerOffset, int stackIndex, boolean markInstructions) {
        if (!this.isStackEntryUnwantedBefore(consumerOffset, stackIndex)) {
            this.markStackEntryProducers(this.partialEvaluator.getStackBefore(consumerOffset).getBottomProducerValue(stackIndex).instructionOffsetValue(), stackIndex, markInstructions);
        }
    }

    private void markStackEntryProducers(InstructionOffsetValue producerOffsets, int stackIndex, boolean markInstructions) {
        if (producerOffsets != null) {
            int offsetCount = producerOffsets.instructionOffsetCount();
            for (int offsetIndex = 0; offsetIndex < offsetCount; ++offsetIndex) {
                if (producerOffsets.isExceptionHandler(offsetIndex)) continue;
                int offset = producerOffsets.instructionOffset(offsetIndex);
                this.markStackEntryAfter(offset, stackIndex);
                if (markInstructions) {
                    this.markInstruction(offset);
                    continue;
                }
                this.markExtraPushPopInstruction(offset);
            }
        }
    }

    private void markReverseDependencies(int instructionOffset) {
        InstructionOffsetValue reverseDependency = this.reverseDependencies[instructionOffset];
        if (reverseDependency != null) {
            this.markInstructions(reverseDependency);
        }
    }

    private void markStraddlingBranches(int instructionOffset, InstructionOffsetValue branchOffsets, boolean isPointingToTargets) {
        if (branchOffsets != null) {
            int branchCount = branchOffsets.instructionOffsetCount();
            for (int branchIndex = 0; branchIndex < branchCount; ++branchIndex) {
                int branchOffset = branchOffsets.instructionOffset(branchIndex);
                if (isPointingToTargets) {
                    this.markStraddlingBranch(instructionOffset, branchOffset, instructionOffset, branchOffset);
                    continue;
                }
                this.markStraddlingBranch(instructionOffset, branchOffset, branchOffset, instructionOffset);
            }
        }
    }

    private void markStraddlingBranch(int instructionOffsetStart, int instructionOffsetEnd, int branchOrigin, int branchTarget) {
        if (!this.isInstructionNecessary(branchOrigin) && this.isAnyInstructionNecessary(instructionOffsetStart, instructionOffsetEnd)) {
            this.markInstruction(branchOrigin);
        }
    }

    private void initializeNecessary(CodeAttribute codeAttribute) {
        int offset;
        int codeLength = codeAttribute.u4codeLength;
        int maxLocals = codeAttribute.u2maxLocals;
        int maxStack = codeAttribute.u2maxStack;
        this.reverseDependencies = (InstructionOffsetValue[])ArrayUtil.ensureArraySize((Object[])this.reverseDependencies, (int)codeLength, null);
        if (this.stacksNecessaryAfter.length < codeLength || this.stacksNecessaryAfter[0].length < maxStack) {
            this.stacksNecessaryAfter = new boolean[codeLength][maxStack];
        } else {
            for (offset = 0; offset < codeLength; ++offset) {
                Arrays.fill(this.stacksNecessaryAfter[offset], 0, maxStack, false);
            }
        }
        if (this.stacksUnwantedBefore.length < codeLength || this.stacksUnwantedBefore[0].length < maxStack) {
            this.stacksUnwantedBefore = new boolean[codeLength][maxStack];
        } else {
            for (offset = 0; offset < codeLength; ++offset) {
                Arrays.fill(this.stacksUnwantedBefore[offset], 0, maxStack, false);
            }
        }
        this.instructionsNecessary = ArrayUtil.ensureArraySize((boolean[])this.instructionsNecessary, (int)codeLength, (boolean)false);
        this.extraPushPopInstructionsNecessary = ArrayUtil.ensureArraySize((boolean[])this.extraPushPopInstructionsNecessary, (int)codeLength, (boolean)false);
    }

    private boolean isVariableInitialization(int instructionOffset, int variableIndex) {
        Value valueBefore = this.simplePartialEvaluator.getVariablesBefore(instructionOffset).getValue(variableIndex);
        if (valueBefore == null) {
            return true;
        }
        Value valueAfter = this.simplePartialEvaluator.getVariablesAfter(instructionOffset).getValue(variableIndex);
        if (valueAfter.computationalType() != valueBefore.computationalType()) {
            return true;
        }
        if (!(valueAfter.computationalType() != 5 || valueAfter.referenceValue().isNull() != 1 && valueAfter.referenceValue().getType().equals(valueBefore.referenceValue().getType()))) {
            return true;
        }
        InstructionOffsetValue producersBefore = this.simplePartialEvaluator.getVariablesBefore(instructionOffset).getProducerValue(variableIndex).instructionOffsetValue();
        return producersBefore.instructionOffsetCount() == 1 && producersBefore.isMethodParameter(0);
    }

    private void markStackEntryAfter(int instructionOffset, int stackIndex) {
        if (!this.isStackEntryNecessaryAfter(instructionOffset, stackIndex)) {
            this.stacksNecessaryAfter[instructionOffset][stackIndex] = true;
            if (this.maxMarkedOffset < instructionOffset) {
                this.maxMarkedOffset = instructionOffset;
            }
        }
    }

    private void markStackEntryUnwantedBefore(int instructionOffset, int stackIndex) {
        this.stacksUnwantedBefore[instructionOffset][stackIndex] = true;
    }

    private void markInstructions(InstructionOffsetValue instructionOffsets) {
        int count = instructionOffsets.instructionOffsetCount();
        for (int index = 0; index < count; ++index) {
            this.markInstruction(instructionOffsets.instructionOffset(index));
        }
    }

    private void markInstruction(int instructionOffset) {
        if (!this.isInstructionNecessary(instructionOffset)) {
            this.instructionsNecessary[instructionOffset] = true;
            if (this.maxMarkedOffset < instructionOffset) {
                this.maxMarkedOffset = instructionOffset;
            }
        }
    }

    private void markExtraPushPopInstruction(int instructionOffset) {
        if (!this.isInstructionNecessary(instructionOffset) && !this.isExtraPushPopInstructionNecessary(instructionOffset)) {
            this.extraPushPopInstructionsNecessary[instructionOffset] = true;
            if (this.maxMarkedOffset < instructionOffset) {
                this.maxMarkedOffset = instructionOffset;
            }
        }
    }

    private boolean isAnyInstructionNecessary(int startInstructionOffset, int endInstructionOffset) {
        for (int instructionOffset = startInstructionOffset; instructionOffset < endInstructionOffset; ++instructionOffset) {
            if (!this.isInstructionNecessary(instructionOffset) && !this.isExtraPushPopInstructionNecessary(instructionOffset)) continue;
            return true;
        }
        return false;
    }

    private class MyNecessaryInstructionFilter
    implements InstructionVisitor {
        private final boolean necessary;
        private final InstructionVisitor instructionVisitor;

        public MyNecessaryInstructionFilter(boolean necessary, InstructionVisitor instructionVisitor) {
            this.necessary = necessary;
            this.instructionVisitor = instructionVisitor;
        }

        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
            if (this.shouldVisit(offset)) {
                this.instructionVisitor.visitSimpleInstruction(clazz, method, codeAttribute, offset, simpleInstruction);
            }
        }

        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
            if (this.shouldVisit(offset)) {
                this.instructionVisitor.visitVariableInstruction(clazz, method, codeAttribute, offset, variableInstruction);
            }
        }

        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            if (this.shouldVisit(offset)) {
                this.instructionVisitor.visitConstantInstruction(clazz, method, codeAttribute, offset, constantInstruction);
            }
        }

        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
            if (this.shouldVisit(offset)) {
                this.instructionVisitor.visitBranchInstruction(clazz, method, codeAttribute, offset, branchInstruction);
            }
        }

        public void visitTableSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, TableSwitchInstruction tableSwitchInstruction) {
            if (this.shouldVisit(offset)) {
                this.instructionVisitor.visitTableSwitchInstruction(clazz, method, codeAttribute, offset, tableSwitchInstruction);
            }
        }

        public void visitLookUpSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, LookUpSwitchInstruction lookUpSwitchInstruction) {
            if (this.shouldVisit(offset)) {
                this.instructionVisitor.visitLookUpSwitchInstruction(clazz, method, codeAttribute, offset, lookUpSwitchInstruction);
            }
        }

        private boolean shouldVisit(int offset) {
            return InstructionUsageMarker.this.isInstructionNecessary(offset) == this.necessary;
        }
    }

    private class MyExtraPushPopInstructionMarker
    implements InstructionVisitor {
        private MyExtraPushPopInstructionMarker() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
            int firstStackIndex;
            int stackSize = InstructionUsageMarker.this.partialEvaluator.getStackBefore(offset).size();
            for (int stackIndex = firstStackIndex = stackSize - instruction.stackPopCount(clazz); stackIndex < stackSize; ++stackIndex) {
                if (InstructionUsageMarker.this.isStackEntryUnwantedBefore(offset, stackIndex) || !InstructionUsageMarker.this.isStackEntryPresentBefore(offset, stackIndex)) continue;
                InstructionUsageMarker.this.markExtraPushPopInstruction(offset);
                InstructionUsageMarker.this.markStackEntryProducers(offset, stackIndex, false);
            }
        }
    }

    private class MyStackConsistencyMarker
    implements InstructionVisitor {
        private MyStackConsistencyMarker() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
            int stackSize = InstructionUsageMarker.this.partialEvaluator.getStackBefore(offset).size();
            for (int stackIndex = 0; stackIndex < stackSize; ++stackIndex) {
                if (InstructionUsageMarker.this.isStackEntryUnwantedBefore(offset, stackIndex) || !InstructionUsageMarker.this.isStackEntryPresentBefore(offset, stackIndex)) continue;
                InstructionUsageMarker.this.markStackEntryProducers(offset, stackIndex, false);
            }
        }
    }

    private class MyVariableInitializationMarker
    implements InstructionVisitor {
        private MyVariableInitializationMarker() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        }

        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
            if (variableInstruction.isLoad()) {
                InstructionUsageMarker.this.markVariableInitializersBefore(offset, variableInstruction.variableIndex, null);
            }
        }
    }

    private class MyProducerMarker
    implements InstructionVisitor {
        private MyProducerMarker() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
            InstructionUsageMarker.this.markStackProducers(clazz, offset, instruction);
        }

        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
            switch (simpleInstruction.opcode) {
                case 89: {
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(offset, 0, 0);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(offset, 1, 0);
                    break;
                }
                case 90: {
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(offset, 0, 0);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(offset, 1, 1);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(offset, 2, 0);
                    break;
                }
                case 91: {
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(offset, 0, 0);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(offset, 1, 1);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(offset, 2, 2);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(offset, 3, 0);
                    break;
                }
                case 92: {
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(offset, 0, 0);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(offset, 1, 1);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(offset, 2, 0);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(offset, 3, 1);
                    break;
                }
                case 93: {
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(offset, 0, 0);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(offset, 1, 1);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(offset, 2, 2);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(offset, 3, 0);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(offset, 4, 1);
                    break;
                }
                case 94: {
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(offset, 0, 0);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(offset, 1, 1);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(offset, 2, 2);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(offset, 3, 3);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(offset, 4, 0);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(offset, 5, 1);
                    break;
                }
                case 95: {
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(offset, 0, 1);
                    InstructionUsageMarker.this.conditionallyMarkStackEntryProducers(offset, 1, 0);
                    break;
                }
                default: {
                    InstructionUsageMarker.this.markStackProducers(clazz, offset, (Instruction)simpleInstruction);
                }
            }
        }

        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
            if (variableInstruction.isLoad()) {
                InstructionUsageMarker.this.markVariableProducers(offset, variableInstruction.variableIndex);
            } else {
                InstructionUsageMarker.this.markStackProducers(clazz, offset, (Instruction)variableInstruction);
            }
        }

        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            InstructionUsageMarker.this.markStackProducers(clazz, offset, (Instruction)constantInstruction);
        }

        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
            if (branchInstruction.opcode == -88 || branchInstruction.opcode == -55) {
                InstructionUsageMarker.this.markStackEntryAfter(offset, 0);
            } else {
                InstructionUsageMarker.this.markStackProducers(clazz, offset, (Instruction)branchInstruction);
            }
        }
    }

    private class MyInitialUsageMarker
    implements InstructionVisitor,
    ConstantVisitor,
    ParameterVisitor {
        private final MemberVisitor reverseDependencyCreator = new AllParameterVisitor(true, (ParameterVisitor)this);
        private int referencingOffset;
        private int referencingPopCount;

        private MyInitialUsageMarker() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
            if (InstructionUsageMarker.this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, offset, instruction)) {
                InstructionUsageMarker.this.markInstruction(offset);
            }
        }

        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
            switch (simpleInstruction.opcode) {
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    this.createReverseDependencies(clazz, offset, (Instruction)simpleInstruction);
                    this.visitAnyInstruction(clazz, method, codeAttribute, offset, (Instruction)simpleInstruction);
                    break;
                }
                default: {
                    this.visitAnyInstruction(clazz, method, codeAttribute, offset, (Instruction)simpleInstruction);
                }
            }
        }

        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            switch (constantInstruction.opcode) {
                case -67: 
                case -59: {
                    this.referencingOffset = offset;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, (ConstantVisitor)this);
                    this.visitAnyInstruction(clazz, method, codeAttribute, offset, (Instruction)constantInstruction);
                    break;
                }
                case -78: 
                case -69: 
                case 18: 
                case 19: {
                    this.referencingOffset = offset;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, (ConstantVisitor)this);
                    break;
                }
                case -75: {
                    if (!InstructionUsageMarker.this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, offset, (Instruction)constantInstruction)) break;
                    this.createReverseDependencies(clazz, offset, (Instruction)constantInstruction);
                    break;
                }
                case -74: 
                case -73: 
                case -72: 
                case -71: {
                    this.referencingOffset = offset;
                    this.referencingPopCount = constantInstruction.stackPopCount(clazz);
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, (ConstantVisitor)this);
                    break;
                }
                default: {
                    this.visitAnyInstruction(clazz, method, codeAttribute, offset, (Instruction)constantInstruction);
                }
            }
        }

        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
            if (branchInstruction.opcode == -89 && branchInstruction.branchOffset == 0) {
                InstructionUsageMarker.this.markInstruction(offset);
            } else {
                this.visitAnyInstruction(clazz, method, codeAttribute, offset, (Instruction)branchInstruction);
            }
        }

        public void visitAnyConstant(Clazz clazz, Constant constant) {
        }

        public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
            Clazz referencedClass = stringConstant.referencedClass;
            if (referencedClass != null && SideEffectClassChecker.mayHaveSideEffects(clazz, referencedClass)) {
                InstructionUsageMarker.this.markInstruction(this.referencingOffset);
            }
        }

        public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
            Clazz referencedClass = classConstant.referencedClass;
            if (referencedClass == null || SideEffectClassChecker.mayHaveSideEffects(clazz, referencedClass)) {
                InstructionUsageMarker.this.markInstruction(this.referencingOffset);
            }
        }

        public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
            clazz.constantPoolEntryAccept(fieldrefConstant.u2classIndex, (ConstantVisitor)this);
        }

        public void visitAnyMethodrefConstant(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant) {
            Method referencedMethod = anyMethodrefConstant.referencedMethod;
            if (SideEffectInstructionChecker.OPTIMIZE_CONSERVATIVELY && referencedMethod != null && SideEffectMethodMarker.hasSideEffects(referencedMethod) && !NoExternalSideEffectMethodMarker.hasNoExternalSideEffects(referencedMethod)) {
                InstructionUsageMarker.this.markInstruction(this.referencingOffset);
            } else if (referencedMethod == null || ParameterEscapeMarker.getEscapingParameters(referencedMethod) != 0L || ParameterEscapeMarker.modifiesAnything(referencedMethod) || SideEffectClassChecker.mayHaveSideEffects(clazz, anyMethodrefConstant.referencedClass, (Member)referencedMethod)) {
                InstructionUsageMarker.this.markInstruction(this.referencingOffset);
            } else {
                anyMethodrefConstant.referencedMethodAccept(this.reverseDependencyCreator);
            }
        }

        public void visitParameter(Clazz clazz, Member member, int parameterIndex, int parameterCount, int parameterOffset, int parameterSize, String parameterType, Clazz referencedClass) {
            Method method = (Method)member;
            if (ParameterEscapeMarker.isParameterModified(method, parameterIndex)) {
                this.createReverseDependencies(this.referencingOffset, parameterSize - parameterOffset - 1);
            }
        }

        private void createReverseDependencies(Clazz clazz, int offset, Instruction instruction) {
            this.createReverseDependencies(offset, instruction.stackPopCount(clazz) - 1);
        }

        private void createReverseDependencies(int offset, int stackEntryIndex) {
            ReferenceValue referenceValue;
            TracedStack stackBefore = InstructionUsageMarker.this.partialEvaluator.getStackBefore(offset);
            Value stackEntry = stackBefore.getTop(stackEntryIndex);
            if (stackEntry.computationalType() == 5 && (referenceValue = stackEntry.referenceValue()).isNull() != 1) {
                if (referenceValue instanceof TracedReferenceValue) {
                    TracedReferenceValue tracedReferenceValue = (TracedReferenceValue)referenceValue;
                    this.createReverseDependencies(offset, tracedReferenceValue.getTraceValue().instructionOffsetValue());
                } else {
                    InstructionUsageMarker.this.markInstruction(offset);
                }
            }
        }

        private void createReverseDependencies(int offset, InstructionOffsetValue producerOffsets) {
            InstructionOffsetValue consumerOffset = new InstructionOffsetValue(offset);
            int offsetCount = producerOffsets.instructionOffsetCount();
            for (int offsetIndex = 0; offsetIndex < offsetCount; ++offsetIndex) {
                if (producerOffsets.isNewinstance(offsetIndex)) {
                    int producerOffset = producerOffsets.instructionOffset(offsetIndex);
                    if (producerOffset == offset) continue;
                    InstructionOffsetValue reverseDependency = InstructionUsageMarker.this.reverseDependencies[producerOffset];
                    ((InstructionUsageMarker)InstructionUsageMarker.this).reverseDependencies[producerOffset] = reverseDependency == null ? consumerOffset : reverseDependency.generalize(consumerOffset);
                    continue;
                }
                InstructionUsageMarker.this.markInstruction(offset);
            }
        }
    }

    private class MyParameterUsageMarker
    implements InstructionVisitor,
    ConstantVisitor,
    MemberVisitor {
        private int parameterSize;
        private long usedParameters;

        private MyParameterUsageMarker() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        }

        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            switch (constantInstruction.opcode) {
                case -74: 
                case -73: 
                case -72: 
                case -71: {
                    this.parameterSize = 0;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, (ConstantVisitor)this);
                    for (int index = 0; index < this.parameterSize; ++index) {
                        if (index >= 64 || (this.usedParameters & 1L << index) != 0L) continue;
                        TracedStack stack = InstructionUsageMarker.this.partialEvaluator.getStackBefore(offset);
                        int stackIndex = stack.size() - this.parameterSize + index;
                        InstructionUsageMarker.this.markStackEntryUnwantedBefore(offset, stackIndex);
                    }
                    break;
                }
            }
        }

        public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
            refConstant.referencedMemberAccept((MemberVisitor)this);
        }

        public void visitAnyMember(Clazz clazz, Member member) {
        }

        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
            this.parameterSize = ParameterUsageMarker.getParameterSize((Method)programMethod);
            this.usedParameters = ParameterUsageMarker.getUsedParameters((Method)programMethod);
        }
    }
}

