/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.AnyMethodrefConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.NoSideEffectMethodMarker;
import proguard.optimize.info.ReadWriteFieldMarker;
import proguard.optimize.info.SideEffectClassChecker;
import proguard.optimize.info.SideEffectMethodMarker;

public class SideEffectInstructionChecker
implements InstructionVisitor,
ConstantVisitor,
MemberVisitor {
    public static final boolean OPTIMIZE_CONSERVATIVELY = System.getProperty("optimize.conservatively") != null;
    private final boolean includeReturnInstructions;
    private final boolean includeArrayStoreInstructions;
    private boolean writingField;
    private Clazz referencingClass;
    private boolean hasSideEffects;

    public SideEffectInstructionChecker(boolean includeReturnInstructions, boolean includeArrayStoreInstructions) {
        this.includeReturnInstructions = includeReturnInstructions;
        this.includeArrayStoreInstructions = includeArrayStoreInstructions;
    }

    public boolean hasSideEffects(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        this.hasSideEffects = false;
        instruction.accept(clazz, method, codeAttribute, offset, (InstructionVisitor)this);
        return this.hasSideEffects;
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        byte opcode = simpleInstruction.opcode;
        switch (opcode) {
            case -68: 
            case -66: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                this.hasSideEffects = OPTIMIZE_CONSERVATIVELY;
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.hasSideEffects = this.includeArrayStoreInstructions;
                break;
            }
            case -65: 
            case -62: 
            case -61: {
                this.hasSideEffects = true;
                break;
            }
            case -84: 
            case -83: 
            case -82: 
            case -81: 
            case -80: 
            case -79: {
                this.hasSideEffects = this.includeReturnInstructions;
            }
        }
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        byte opcode = variableInstruction.opcode;
        switch (opcode) {
            case -87: {
                this.hasSideEffects = this.includeReturnInstructions;
            }
        }
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        byte opcode = constantInstruction.opcode;
        switch (opcode) {
            case -78: {
                this.writingField = false;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, (ConstantVisitor)this);
                break;
            }
            case -77: {
                this.writingField = true;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, (ConstantVisitor)this);
                break;
            }
            case -76: {
                if (OPTIMIZE_CONSERVATIVELY) {
                    this.hasSideEffects = true;
                    break;
                }
                this.writingField = false;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, (ConstantVisitor)this);
                break;
            }
            case -75: {
                if (OPTIMIZE_CONSERVATIVELY) {
                    this.hasSideEffects = true;
                    break;
                }
                this.writingField = true;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, (ConstantVisitor)this);
                break;
            }
            case -73: 
            case -72: {
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, (ConstantVisitor)this);
                break;
            }
            case -74: 
            case -71: 
            case -70: {
                if (OPTIMIZE_CONSERVATIVELY) {
                    this.hasSideEffects = true;
                    break;
                }
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, (ConstantVisitor)this);
                break;
            }
            case -67: 
            case -64: 
            case -59: {
                this.hasSideEffects = OPTIMIZE_CONSERVATIVELY;
            }
        }
    }

    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        byte opcode = branchInstruction.opcode;
        switch (opcode) {
            case -88: 
            case -55: {
                this.hasSideEffects = this.includeReturnInstructions;
            }
        }
    }

    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        this.hasSideEffects = true;
    }

    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        this.referencingClass = clazz;
        this.hasSideEffects = true;
        fieldrefConstant.referencedFieldAccept((MemberVisitor)this);
    }

    public void visitAnyMethodrefConstant(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant) {
        this.referencingClass = clazz;
        this.hasSideEffects = true;
        anyMethodrefConstant.referencedMethodAccept((MemberVisitor)this);
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.hasSideEffects = this.writingField && ReadWriteFieldMarker.isRead((Field)programField) || (programField.getAccessFlags() & 0x40) != 0 || SideEffectClassChecker.mayHaveSideEffects(this.referencingClass, (Clazz)programClass, (Member)programField);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.hasSideEffects = SideEffectMethodMarker.hasSideEffects((Method)programMethod) || SideEffectClassChecker.mayHaveSideEffects(this.referencingClass, (Clazz)programClass, (Member)programMethod);
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        this.hasSideEffects = true;
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        this.hasSideEffects = !NoSideEffectMethodMarker.hasNoSideEffects((Method)libraryMethod);
    }
}

