/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.AttributeUsageMarker;
import proguard.util.Processable;

public class AttributeShrinker
implements ClassVisitor,
MemberVisitor,
AttributeVisitor {
    public void visitAnyClass(Clazz clazz) {
    }

    public void visitProgramClass(ProgramClass programClass) {
        programClass.u2attributesCount = AttributeShrinker.shrinkArray((Processable[])programClass.attributes, programClass.u2attributesCount);
        programClass.fieldsAccept((MemberVisitor)this);
        programClass.methodsAccept((MemberVisitor)this);
        programClass.attributesAccept((AttributeVisitor)this);
    }

    public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
        programMember.u2attributesCount = AttributeShrinker.shrinkArray((Processable[])programMember.attributes, programMember.u2attributesCount);
        programMember.attributesAccept(programClass, (AttributeVisitor)this);
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.u2attributesCount = AttributeShrinker.shrinkArray((Processable[])codeAttribute.attributes, codeAttribute.u2attributesCount);
    }

    private static int shrinkArray(Processable[] array, int length) {
        int counter = 0;
        for (int index = 0; index < length; ++index) {
            if (!AttributeUsageMarker.isUsed(array[index])) continue;
            array[counter++] = array[index];
        }
        Arrays.fill(array, counter, length, null);
        return counter;
    }
}

