/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.MultiAttributeVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.ReferencedKotlinMetadataVisitor;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.ClassProcessingFlagFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberProcessingFlagFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.optimize.gson.GsonContext;
import proguard.optimize.gson.OptimizedJsonFieldVisitor;
import proguard.resources.file.ResourceFilePool;
import proguard.resources.file.visitor.ResourceFileNameFilter;
import proguard.resources.file.visitor.ResourceFileProcessingFlagFilter;
import proguard.resources.file.visitor.ResourceFileVisitor;
import proguard.shrink.AnnotationUsageMarker;
import proguard.shrink.ClassUsageMarker;
import proguard.shrink.InnerUsageMarker;
import proguard.shrink.InterfaceUsageMarker;
import proguard.shrink.KotlinModuleUsageMarker;
import proguard.shrink.LocalVariableTypeUsageMarker;
import proguard.shrink.NestUsageMarker;
import proguard.shrink.SimpleUsageMarker;
import proguard.shrink.UsedClassFilter;
import proguard.util.ConstantMatcher;
import proguard.util.ListParser;
import proguard.util.NameParser;
import proguard.util.StringParser;

public class UsageMarker {
    private final Configuration configuration;

    public UsageMarker(Configuration configuration) {
        this.configuration = configuration;
    }

    public void mark(ClassPool programClassPool, ClassPool libraryClassPool, ResourceFilePool resourceFilePool, SimpleUsageMarker simpleUsageMarker) {
        this.mark(programClassPool, libraryClassPool, resourceFilePool, simpleUsageMarker, new ClassUsageMarker(simpleUsageMarker));
    }

    public void mark(ClassPool programClassPool, ClassPool libraryClassPool, ResourceFilePool resourceFilePool, SimpleUsageMarker simpleUsageMarker, ClassUsageMarker classUsageMarker) {
        libraryClassPool.classesAccept((ClassVisitor)classUsageMarker);
        programClassPool.classesAccept((ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{new ClassProcessingFlagFilter(0x100000, 0, (ClassVisitor)classUsageMarker), new AllMemberVisitor((MemberVisitor)new MemberProcessingFlagFilter(0x100000, 0, (MemberVisitor)classUsageMarker))}));
        if (this.configuration.keepKotlinMetadata) {
            programClassPool.classesAccept((ClassVisitor)new ReferencedKotlinMetadataVisitor((KotlinMetadataVisitor)classUsageMarker));
        }
        programClassPool.classesAccept((ClassVisitor)new UsedClassFilter(simpleUsageMarker, (ClassVisitor)new AllAttributeVisitor(true, (AttributeVisitor)new MultiAttributeVisitor(new AttributeVisitor[]{new InnerUsageMarker(classUsageMarker), new NestUsageMarker(classUsageMarker), new AnnotationUsageMarker(classUsageMarker), new LocalVariableTypeUsageMarker(classUsageMarker)}))));
        programClassPool.classesAccept((ClassVisitor)new InterfaceUsageMarker(classUsageMarker));
        if (this.configuration.keepKotlinMetadata) {
            resourceFilePool.resourceFilesAccept((ResourceFileVisitor)new ResourceFileNameFilter("META-INF/*.kotlin_module", (ResourceFileVisitor)new ResourceFileProcessingFlagFilter(0, 8192, (ResourceFileVisitor)new KotlinModuleUsageMarker(simpleUsageMarker))));
        }
        ConstantMatcher filter = this.configuration.optimizations != null ? new ListParser((StringParser)new NameParser()).parse(this.configuration.optimizations) : new ConstantMatcher(true);
        boolean libraryGson = filter.matches("library/gson");
        if (this.configuration.optimize && libraryGson) {
            GsonContext gsonContext = new GsonContext();
            gsonContext.setupFor(programClassPool, libraryClassPool, null);
            if (gsonContext.gsonRuntimeSettings.excludeFieldsWithModifiers) {
                gsonContext.gsonDomainClassPool.classesAccept((ClassVisitor)new MultiClassVisitor(new ClassVisitor[]{classUsageMarker, new AllFieldVisitor((MemberVisitor)classUsageMarker)}));
            } else {
                gsonContext.gsonDomainClassPool.classesAccept((ClassVisitor)new OptimizedJsonFieldVisitor(classUsageMarker, classUsageMarker));
            }
        }
    }
}

