/*
 * Decompiled with CFR 0.152.
 */
package proguard.util.kotlin.asserter.constraint;

import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinPropertyMetadata;
import proguard.classfile.kotlin.visitor.AllKotlinPropertiesVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.KotlinPropertyVisitor;
import proguard.util.kotlin.asserter.AssertUtil;
import proguard.util.kotlin.asserter.constraint.AbstractKotlinMetadataConstraint;

public class PropertyIntegrity
extends AbstractKotlinMetadataConstraint
implements KotlinPropertyVisitor {
    @Override
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        kotlinMetadata.accept(clazz, (KotlinMetadataVisitor)new AllKotlinPropertiesVisitor((KotlinPropertyVisitor)this));
    }

    public void visitAnyProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
        AssertUtil util = new AssertUtil("Property " + kotlinPropertyMetadata.name, this.reporter);
        util.reportIfNull("backingFieldSignature, getterSignature or setterSignature", kotlinPropertyMetadata.backingFieldSignature, kotlinPropertyMetadata.getterSignature, kotlinPropertyMetadata.setterSignature);
        if (kotlinPropertyMetadata.backingFieldSignature != null) {
            util.reportIfNullReference("backing field class", kotlinPropertyMetadata.referencedBackingFieldClass);
            util.reportIfNullReference("backing field", kotlinPropertyMetadata.referencedBackingField);
            util.reportIfFieldDangling("backing field", kotlinPropertyMetadata.referencedBackingFieldClass, kotlinPropertyMetadata.referencedBackingField);
        }
        if (kotlinPropertyMetadata.getterSignature != null) {
            util.reportIfNullReference("getter", kotlinPropertyMetadata.referencedGetterMethod);
        }
        if (kotlinPropertyMetadata.setterSignature != null) {
            util.reportIfNullReference("setter", kotlinPropertyMetadata.referencedSetterMethod);
        }
        if (kotlinPropertyMetadata.syntheticMethodForAnnotations != null) {
            util.reportIfNullReference("synthetic annotations method class", kotlinPropertyMetadata.referencedSyntheticMethodClass);
            util.reportIfNullReference("synthetic annotations method", kotlinPropertyMetadata.referencedSyntheticMethodForAnnotations);
            util.reportIfMethodDangling("synthetic annotations method", kotlinPropertyMetadata.referencedSyntheticMethodClass, kotlinPropertyMetadata.referencedSyntheticMethodForAnnotations);
        }
    }
}

