/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassVisitor;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.InvocationUnit;
import proguard.evaluation.PartialEvaluator;
import proguard.evaluation.ReferenceTracingInvocationUnit;
import proguard.evaluation.ReferenceTracingValueFactory;
import proguard.evaluation.SimplifiedInvocationUnit;
import proguard.evaluation.TracedStack;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TypedReferenceValueFactory;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.info.ClassOptimizationInfo;
import proguard.optimize.info.ProgramClassOptimizationInfo;
import proguard.optimize.info.ReferenceEscapeChecker;

public class EscapingClassMarker
implements AttributeVisitor,
InstructionVisitor,
ClassVisitor {
    private static final boolean DEBUG = false;
    private final PartialEvaluator partialEvaluator;
    private final boolean runPartialEvaluator;
    private final ReferenceEscapeChecker referenceEscapeChecker;
    private final boolean runReferenceEscapeChecker;

    public EscapingClassMarker() {
        this((ValueFactory)new TypedReferenceValueFactory());
    }

    public EscapingClassMarker(ValueFactory valueFactory) {
        this(new ReferenceTracingValueFactory(valueFactory));
    }

    public EscapingClassMarker(ReferenceTracingValueFactory tracingValueFactory) {
        this(new PartialEvaluator((ValueFactory)tracingValueFactory, (InvocationUnit)new ReferenceTracingInvocationUnit((SimplifiedInvocationUnit)new BasicInvocationUnit((ValueFactory)tracingValueFactory)), true, (InstructionVisitor)tracingValueFactory), true);
    }

    public EscapingClassMarker(PartialEvaluator partialEvaluator, boolean runPartialEvaluator) {
        this(partialEvaluator, runPartialEvaluator, new ReferenceEscapeChecker(partialEvaluator, false), true);
    }

    public EscapingClassMarker(PartialEvaluator partialEvaluator, boolean runPartialEvaluator, ReferenceEscapeChecker referenceEscapeChecker, boolean runReferenceEscapeChecker) {
        this.partialEvaluator = partialEvaluator;
        this.runPartialEvaluator = runPartialEvaluator;
        this.referenceEscapeChecker = referenceEscapeChecker;
        this.runReferenceEscapeChecker = runReferenceEscapeChecker;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (this.runPartialEvaluator) {
            this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        }
        if (this.runReferenceEscapeChecker) {
            this.referenceEscapeChecker.visitCodeAttribute(clazz, method, codeAttribute);
        }
        codeAttribute.instructionsAccept(clazz, method, this.partialEvaluator.tracedInstructionFilter((InstructionVisitor)this));
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        Clazz referencedClass;
        ReferenceValue referenceValue;
        TracedStack stackAfter;
        Value stackEntry;
        if (instruction.stackPushCount(clazz) == 1 && (this.referenceEscapeChecker.isInstanceEscaping(offset) || this.referenceEscapeChecker.isInstanceReturned(offset)) && (stackEntry = (stackAfter = this.partialEvaluator.getStackAfter(offset)).getTop(0)).computationalType() == 5 && (referenceValue = stackEntry.referenceValue()).isNull() != 1 && !ClassUtil.isInternalArrayType((String)referenceValue.getType()) && (referencedClass = referenceValue.getReferencedClass()) != null) {
            referencedClass.hierarchyAccept(true, true, true, false, (ClassVisitor)this);
        }
    }

    public void visitAnyClass(Clazz clazz) {
    }

    public void visitProgramClass(ProgramClass programClass) {
        this.markClassEscaping((Clazz)programClass);
    }

    private void markClassEscaping(Clazz clazz) {
        ClassOptimizationInfo info = ProgramClassOptimizationInfo.getClassOptimizationInfo(clazz);
        if (info instanceof ProgramClassOptimizationInfo) {
            ((ProgramClassOptimizationInfo)info).setEscaping();
        }
    }

    public static boolean isClassEscaping(Clazz clazz) {
        return ClassOptimizationInfo.getClassOptimizationInfo(clazz).isEscaping();
    }
}

